<?php

declare(strict_types=1);

namespace FiloBlu\Venistar\Esb\Consumer;

use FiloBlu\Esb\Api\Data\MessageInterface;
use FiloBlu\Esb\Api\Data\StatusInterface;
use Magento\Rma\Api\Data\RmaInterface;
use Throwable;

/**
 *
 */
class SendRmaToVenistar extends SendObjectToFtpConsumer
{

    /**
     * @param \FiloBlu\Esb\Api\Data\MessageInterface $message
     * @return \FiloBlu\Esb\Api\Data\MessageInterface
     * @throws \FiloBlu\Esb\Core\Exception\NonRecoverableException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function consume(MessageInterface $message): MessageInterface
    {
        $rma = $this->loadObject($message);

        try {
            $filename = $this->getFileName($rma);
            $fileUploaded = $this->uploadFile($filename, $this->createFile($filename, $rma));
        } catch (Throwable $throwable) {
            $this->getStatus()
                ->setCode(StatusInterface::ERROR)
                ->appendOutputData(
                    "Can't generate JSON from rma {$rma->getIncrementId()}\n" . $throwable->getMessage(
                    ) . "\n" . $throwable->getTraceAsString()
                );
            return $this->messageFactory->create();
        }

        if (!$fileUploaded) {
            $this->getStatus()->setCode(StatusInterface::ERROR);
            $this->getStatus()->appendOutputData("File upload on FTP failed for rma {$rma->getIncrementId()}");
            return $this->messageFactory->create();
        }

        $this->getStatus()->setCode(StatusInterface::SUCCESS);
        $this->getStatus()->appendOutputData("File uploaded on FTP successfully for rma {$rma->getIncrementId()}");
        return $this->messageFactory->create();
    }

    /**
     * @param \Magento\Rma\Api\Data\RmaInterface $rma
     * @return string
     */
    public function getFileName(RmaInterface $rma): string
    {
        return sprintf('rma_%s_%s_%s.json', $rma->getIncrementId(), $rma->getStatus(), date('YmdHis'));
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return 'venistar_rma_sender';
    }

    /**
     * @return string
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Venistar::rma_sender';
    }
}
