<?php

declare(strict_types=1);

namespace FiloBlu\Venistar\Esb\Consumer;

use FiloBlu\Esb\Api\Data\MessageInterfaceFactory;
use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\StatusInterfaceFactory;
use FiloBlu\Esb\Converter\ConverterResolverInterface;
use FiloBlu\Esb\Core\Expression\EvaluatorInterfaceFactory;
use FiloBlu\Esb\Core\Extractor\ObjectTypeFromMessage;
use FiloBlu\Esb\Framework\Consumer\AbstractConsumer;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Io\IoInterface;
use Psr\Log\LoggerInterface;

/**
 *
 */
abstract class SendObjectToFtpConsumer extends AbstractConsumer
{


    /**
     * @var \Magento\Framework\Filesystem\Io\IoInterface
     */
    private $ftp;
    /**
     * @var \FiloBlu\Esb\Converter\ConverterResolverInterface
     */
    private $converterResolver;
    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;


    /**
     * @param \FiloBlu\Esb\Core\Expression\EvaluatorInterfaceFactory $evaluatorFactory
     * @param \FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface $objectTypeDescriptor
     * @param \FiloBlu\Esb\Api\Data\MessageInterfaceFactory $messageFactory
     * @param \FiloBlu\Esb\Core\Extractor\ObjectTypeFromMessage $objectTypeFromMessage
     * @param \FiloBlu\Esb\Api\Data\StatusInterfaceFactory $statusFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Framework\Filesystem\Io\IoInterface $ftp
     * @param \FiloBlu\Esb\Converter\ConverterResolverInterface $converterResolver
     * @param \Magento\Framework\Filesystem $filesystem
     */
    public function __construct(
        EvaluatorInterfaceFactory $evaluatorFactory,
        ObjectTypeDescriptorInterface $objectTypeDescriptor,
        MessageInterfaceFactory $messageFactory,
        ObjectTypeFromMessage $objectTypeFromMessage,
        StatusInterfaceFactory $statusFactory,
        LoggerInterface $logger,
        IoInterface $ftp,
        ConverterResolverInterface $converterResolver,
        Filesystem $filesystem
    ) {
        parent::__construct(
            $evaluatorFactory,
            $objectTypeDescriptor,
            $messageFactory,
            $objectTypeFromMessage,
            $statusFactory,
            $logger
        );
        $this->ftp = $ftp;
        $this->converterResolver = $converterResolver;
        $this->filesystem = $filesystem;
    }


    /**
     * @param $filename
     * @param $data
     * @return bool
     */
    public function uploadFile($filename, $data)
    {
        $parameters = $this->getConfiguration()->getParameters();

        $args = [
            'host'     => $parameters->getDataByPath('ftp/host'),
            'user'     => $parameters->getDataByPath('ftp/username'),
            'password' => $parameters->getDataByPath('ftp/password'),
            'passive'  => (bool)$parameters->getDataByPath('ftp/passive'),
            'path'     => $parameters->getDataByPath('ftp/ftp_dir'),
            //  'timeout'  => self::CONNECTION_TIMEOUT,
        ];

        if (!$this->ftp->open($args)) {
            return false;
        }
        if (!$this->ftp->cd($parameters->getDataByPath('ftp/ftp_dir'))) {
            return false;
        }
        if (!$this->ftp->write($filename, $data)) {
            return false;
        }
        if (!$this->ftp->close()) {
            return false;
        }

        return true;
    }

    /**
     * @param $filename
     * @param  $object
     * @return bool|string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\FileSystemException
     */
    public function createFile($filename, $object)
    {
        $parameters = $this->getConfiguration()->getParameters();
        $localDirectory = $parameters->getDataByPath('ftp/local_dir');

        $this->getFileSystem()->getDirectoryWrite(DirectoryList::VAR_DIR);

        $order = $this->getConverterResolver()->getFor($object)->convert($object);

        if($parameters->getDataByPath('replace_status')!== null) {
            $order->setData('status', $parameters->getDataByPath('replace_status'));
        }

        if($parameters->getDataByPath('venistar_order_source') !== null) {
            $order->setData('venistar_order_source', $parameters->getDataByPath('venistar_order_source'));
        }

        $json = $order->toJson();

        if ($parameters->getDataByPath('ftp/save_local_file')) {
            $this->getFileSystem()->getDirectoryWrite(DirectoryList::VAR_DIR)->writeFile(
                $localDirectory . DIRECTORY_SEPARATOR . $filename,
                $json,
                'wb'
            );
        }
        return $json;
    }

    /**
     * @return \Magento\Framework\Filesystem
     */
    public function getFileSystem(): Filesystem
    {
        return $this->filesystem;
    }

    /**
     * @return \FiloBlu\Esb\Converter\ConverterResolverInterface
     */
    public function getConverterResolver(): ConverterResolverInterface
    {
        return $this->converterResolver;
    }
}
