<?php

namespace FiloBlu\ProductUrlTools\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class UpgradeSchema implements  UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup,
                            ModuleContextInterface $context){

        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {

            $tableName = $setup->getTable('filoblu_duplicated_attribute_option');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == false) {

                $table = $setup->getConnection()
                    ->newTable($setup->getTable('filoblu_duplicated_attribute_option'))
                    ->addColumn(
                        'id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                        'ID'
                    )
                    ->addColumn(
                        'entity_id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => '0'],
                        'Original row ID'
                    )
                    ->addColumn(
                        'sku',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        ['nullable' => true, 'default' => ''],
                        'SKU'
                    )
                    ->addColumn(
                        'attribute_id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => '0'],
                        'Attribute ID'
                    )
                    ->addColumn(
                        'attribute_code',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        ['nullable' => true, 'default' => ''],
                        'Attribute coded'
                    )
                    ->addColumn(
                        'attribute_value',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        ['nullable' => true, 'default' => ''],
                        'Attribute value'
                    )
                    ->addColumn(
                        'backend_type',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        255,
                        ['nullable' => true, 'default' => ''],
                        'Backend type'
                    )
                    ->addColumn(
                        'original_option_id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => '0'],
                        'Original Option ID'
                    )
                    ->addColumn(
                        'option_id',
                        \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => '0'],
                        'Option ID'
                    )
                    ->addColumn(
                        'processed',
                        \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => '0'],
                        'Processed'
                    )
                    ->addColumn(
                        'created_at',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                        'Created at'
                    )
                    ->addColumn(
                        'updated_at',
                        \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                        null,
                        ['unsigned' => true, 'nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
                        'Updated at'
                    )
                    ->setComment("Custom User table");
                $setup->getConnection()->createTable($table);

            }
        }

        $setup->endSetup();
    }
}