<?php

namespace FiloBlu\ProductUrlTools\Helper;

use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class Progress
 * @package FiloBlu\ProductUrlTools\Helper
 */
class Progress
{
    /**
     * @var ProgressBar[]
     */
    protected $progressBar = [];
    /**
     * @var OutputInterface
     */
    protected $output;
    /**
     * @var bool
     */
    protected $upLineString;

    /**
     * @param OutputInterface $output
     */
    public function bind(OutputInterface $output)
    {
        $this->output = $output;
        ProgressBar::setFormatDefinition('custom', ' %message% / %current%/%max% [%bar%] %percent:3s%% %elapsed:6s% ');
    }

    /**
     * @param $id
     * @param int $max Maximum steps (0 if unknown)
     * @param null $label
     */
    public function add($id, $max = 0, $label = null)
    {
        $this->progressBar[$id] = new ProgressBar($this->output, $max);
        $this->progressBar[$id]->setFormat('custom');
        $this->progressBar[$id]->setOverwrite(true);
        $this->progressBar[$id]->setMessage($label ?? $id);
    }

    public function start()
    {
        $this->output->write("\033[2J");
        $i = 1;
        foreach ($this->progressBar as $progressBar) {
            $this->output->write("\033[$i;0H");
            $progressBar->start();
            $i++;
        }
    }

    /**
     * @param $id
     * @param int $step Number of steps to advance
     */
    public function advance($id, $step = 1)
    {
        $i = 1;
        foreach ($this->progressBar as $idx => $progressBar) {
            if ($idx == $id) {
                $this->output->write("\033[$i;0H");
                $progressBar->advance($step);
                return;
            }
            $i++;
        }
    }

    /**
     * @param $id
     */
    public function finish($id)
    {
        $this->progressBar[$id]->finish();
    }
}
