<?php


namespace FiloBlu\ProductUrlTools\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Framework\Unserialize\Unserialize;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

use function is_array;

/**
 *
 */
class Data
{
    /**
     * @var \Magento\Framework\DB\Adapter\AdapterInterface
     */
    protected $resourceConnection;

    /**
     * @var \Magento\Framework\DB\Adapter\AdapterInterface
     */
    protected $connection;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $config
     * @param \Magento\Framework\App\ResourceConnection $resource
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        ScopeConfigInterface $config,
        ResourceConnection $resource,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger
    ) {
        $this->resourceConnection = $resource;
        $this->scopeConfig = $config;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    /**
     * @param $optionId
     * @return array
     */
    public function getAttributeOptionValueById($optionId)
    {
        $connection = $this->getConnection();

        $productsQuery = $connection
                              ->select()
                              ->from('eav_attribute_option_value')
                              ->where('store_id = 0')
                              ->where('option_id = ' . $optionId)
        ;
        return $connection
                    ->fetchAll($productsQuery)
        ;
    }

    /**
     * @return \Magento\Framework\DB\Adapter\AdapterInterface|object|resource|null
     */
    public function getConnection()
    {
        if ($this->connection === null) {
            $this->connection = $this->resourceConnection->getConnection();
        }

        return $this->connection;
    }

    /**
     * @param $optionId
     * @return int
     */
    public function countAttributeOptionValueById($optionId)
    {
        $connection = $this->getConnection();
        $productsQuery = $connection
                              ->select()
                              ->from('eav_attribute_option_value')
                              ->where('option_id = ' . $optionId)
        ;

        $res = $connection
                    ->fetchAll($productsQuery)
        ;
        return ($res) ? count($res) : 0;
    }

    /**
     * @param $optionValue
     * @param $notIn
     * @return array
     */
    public function getAttributeOptionValueByValue($optionValue, $notIn = '')
    {
        $connection = $this->getConnection();

        $productsQuery = $connection
                              ->select()
                              ->from('eav_attribute_option_value')
                              ->where('value = "' . $optionValue . '"')
                              ->where('store_id = 0')
        ;

        if ($notIn) {
            $productsQuery->where('option_id NOT IN (' . $notIn . ')');
        }

        return $connection
                    ->fetchAll($productsQuery)
        ;
    }

    /**
     * @return array
     */
    public function getAttributeTypes()
    {
        //SELECT x.* FROM forteforte.eav_attribute x
        //WHERE attribute_code LIKE '%color%'
        $connection = $this->getConnection();
        $attributesQuery = $connection
                                ->select()
                                ->from('eav_attribute')
                                ->where('entity_type_id = 4')
                                ->where('frontend_input = "select"')
        ;
        return $connection
                    ->fetchAll($attributesQuery)
        ;
    }

    /**
     * @param $optionId
     * @param $type
     * @return array
     */
    public function getProducts($optionId, $type = 'int')
    {
        $connection = $this->getConnection();
        $productsQuery = $connection
                              ->select()
                              ->from('catalog_product_entity AS cpe', ['row_id', 'entity_id', 'sku'])
                              ->joinInner(
                                  'catalog_product_entity_' . $type . ' AS cpei',
                                  'cpe.row_id = cpei.row_id',
                                  ['attribute_id', 'value']
                              )
                              ->joinInner(
                                  'eav_attribute_option_value AS eaov',
                                  'cpei.value = eaov.option_id',
                                  ['value', 'option_id']
                              )
                              ->where('eaov.option_id = ' . $optionId)
                              ->where('eaov.store_id = 0')
        ;
        return $connection
                    ->fetchAll($productsQuery)
        ;
    }

    /**
     * @param $item
     * @param $array
     * @param $column
     * @return false|int|string
     */
    public function arraySearch($item, $array, $column)
    {
        try {
            foreach ($array as $key => $value) {

                if (is_array($value)) {
                    array_walk_recursive($value, function ($v, $k) use ($item, $key, $value, &$val) {
                        if (strpos($v, $item) !== false) {
                            $val = $key;
                        }
                    });
                    continue;
                }

                if (strpos($value, $item) !== false) {
                    $val = $key;
                }
            }
            return $val;
        } catch (Exception $e) {
            return false;
        }
    }

    /**
     * @param $a
     * @param $b
     * @return int
     */
    public function sortCount($a, $b)
    {
        if ($a['products'] == $b['products']) {
            return 0;
        }
        return $a['products'] < $b['products'] ? 1 : -1;
    }

    /**
     * @return array
     */
    public function getAttributeConfig()
    {
        $attributes = $this->getSerializedValue($this->scopeConfig->getValue('producturltools/general/attribute'));
        $attributes = array_values($attributes);

        foreach ($attributes as $value) {
            $attributesExploded [] =  $value['column_name'];
        }

        return $attributesExploded;
    }

    /**
     * @param string $value
     * @return mixed
     */
    public function getSerializedValue($value)
    {
        if ($this->isSerialized($value)) {
            $unserializer = ObjectManager::getInstance()
                                         ->get(Unserialize::class)
            ;
        } else {
            $unserializer = ObjectManager::getInstance()
                                         ->get(Json::class)
            ;
        }

        return $unserializer->unserialize($value);
    }

    /**
     * @param $value
     * @return bool
     */
    public function isSerialized($value)
    {
        return (boolean)preg_match('/^((s|i|d|b|a|O|C):|N;)/', $value);
    }

    /**
     * @param $storeId
     * @return string
     */
    public function getStoreCode($storeId)
    {
        try {
            return $this->storeManager->getStore($storeId)
                                      ->getCode();
        } catch (NoSuchEntityException $e) {
            $this->logger->error($e);
            return $storeId;
        }
    }
}
