<?php

namespace FiloBlu\ProductUrlTools\Console\Command;

use FiloBlu\ProductUrlTools\Helper\Category;
use FiloBlu\ProductUrlTools\Helper\Progress;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class RegenerateCategoryUrlCommand
 * @package FiloBlu\ProductUrlTools\Console\Command
 */
class RegenerateCategoryUrlCommand extends Command
{
    /**
     * @var Category
     */
    protected $categoryHelper;

    /**
     * RegenerateCategoryUrlCommand constructor.
     * @param Category $categoryHelper
     * @param null $name
     */
    public function __construct(
        Category $categoryHelper,
        $name = null
    )
    {
        $this->categoryHelper = $categoryHelper;
        parent::__construct($name);
    }

    /**
     * Configure the command
     */
    protected function configure()
    {
        $this->setName('tools:regeneratecategory')
            ->setDescription('Regenerate Url\'s for categories');

    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $progress  = new Progress();
        $progress->bind($output);
        $this->categoryHelper->regenerateUrlPathFromUrlKey(
            $progress
        );
        return 0;
    }
}
