<?php

namespace FiloBlu\ProductUrlTools\Console\Command;

use Symfony\Component\Process\Exception\RuntimeException;
use Symfony\Component\Process\PhpExecutableFinder;
use Symfony\Component\Process\Process;

/**
 * Class ExecutorGroup
 * @package FiloBlu\ProductUrlTools\Console\Command
 */
class ExecutorGroup
{
    /**
     * @var array
     */
    protected $processes = [];

    /**
     * @var string
     */
    protected $phpBinaryPath;

    /**
     * @param string $commandline The command line to run
     * @param string|null $cwd The working directory or null to use the working dir of the current PHP process
     * @param array|null $env The environment variables or null to use the same environment as the current PHP process
     * @param string|null $input The input
     * @param int|float|null $timeout The timeout in seconds or null to disable
     * @param array $options An array of options for proc_open
     *
     * @throws RuntimeException When proc_open is not installed
     */
    public function addPhpCommand($commandline, $cwd = null, array $env = null, $input = null, $timeout = 60, array $options = array())
    {
        if (!$this->phpBinaryPath) {
            $phpBinaryFinder = new PhpExecutableFinder();
            $this->phpBinaryPath = $phpBinaryFinder->find();
        }

        $this->processes[] = new Process($commandline, $cwd, $env, $input, $timeout, $options);
    }

    /**
     *
     */
    public function executeAndWaitAll()
    {
        $process = null;
        foreach ($this->processes as $k => &$process) {
            $process->setTimeout(3600);
          //  $process->setTty(Process::isTtySupported());
            $process->start();
        }

        unset($process);

        $processesSize = count($this->processes);
        $processesFinishedSize = 0;

        while ($processesSize !== $processesFinishedSize) {
            foreach ($this->processes as $processKey => $process) {

                if (!$process->isRunning()) {
                    $processesFinishedSize++;
                    unset($this->processes[$processKey]);
                }
            }
        }
    }
}