<?php

namespace FiloBlu\ThresholdTaxes\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 *
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @param \Magento\Framework\Setup\SchemaSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {
            // Get module table
            $tableName = $setup->getTable('tax_calculation_rate');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName)) {
                // Declare data
                $columns = [
                    'from_total' => [
                        'type' => Table::TYPE_DECIMAL ,
                        'length' => '12,4',
                        'nullable' => true ,
                        'unsigned' => false,
                        'comment' => 'From Total' ,
                    ] ,
                    'to_total' => [
                        'type' => Table::TYPE_DECIMAL ,
                        'length' => '12,4',
                        'nullable' => true ,
                        'unsigned' => false,
                        'comment' => 'To Total' ,
                    ] ,
                ];

                $connection = $setup->getConnection();

                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        $setup->endSetup();
    }
}
