<?php

namespace FiloBlu\ThresholdTaxes\Plugin;

use FiloBlu\ThresholdTaxes\Model\QuoteLocator;
use Magento\Quote\Model\Quote;

/**
 *
 */
class QuoteRegistry
{
    /**
     * @var \FiloBlu\ThresholdTaxes\Model\QuoteLocator
     */
    private $quoteLocator;

    /**
     * @param \FiloBlu\ThresholdTaxes\Model\QuoteLocator $quoteLocator
     */
    public function __construct(QuoteLocator $quoteLocator)
    {
        $this->quoteLocator = $quoteLocator;
    }
    /**
     * @param Quote $subject
     * @return array|null
     */
    public function beforeCollectTotals(Quote $subject)
    {
        $this->quoteLocator->setQuote($subject);
        return null;
    }
}
