<?php

namespace FiloBlu\ThresholdTaxes\Plugin\Model\Sales\Total\Quote;

use FiloBlu\ThresholdTaxes\Helper\Data;
use FiloBlu\ThresholdTaxes\Model\Calculation;
use Magento\Framework\Registry;
use Magento\Quote\Api\Data\ShippingAssignmentInterface;
use Magento\Quote\Model\Quote;
use Magento\Quote\Model\Quote\Address\Total;

/**
 *
 */
class Tax
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Registry
     */
    private $registry;

    /**
     * @param Registry $registry
     * @param Data $helper
     */
    public function __construct(
        Registry $registry,
        Data $helper
    ) {
        $this->registry = $registry;
        $this->helper = $helper;
    }

    /**
     * @param \Magento\Tax\Model\Sales\Total\Quote\Tax $subject
     * @return array|null
     */
    public function beforeCollect(
        \Magento\Tax\Model\Sales\Total\Quote\Tax $subject
    ) {

        if (!$this->helper->isEnabled()) {
            return null;
        }

        $this->registry->register(Calculation::THRESHOLD_TAX_APPLY, true);

        return null;
    }

    /**
     * @param \Magento\Tax\Model\Sales\Total\Quote\Tax $subject
     * @param $result
     * @return mixed
     */
    public function afterCollect(
        \Magento\Tax\Model\Sales\Total\Quote\Tax $subject,
        $result
    ) {

        if (!$this->helper->isEnabled()) {
            return $result;
        }

        $this->registry->unregister(Calculation::THRESHOLD_TAX_APPLY);
        return $result;
    }
}
