<?php

namespace FiloBlu\ThresholdTaxes\Plugin\Model\Rate;

use FiloBlu\ThresholdTaxes\Helper\Data;

/**
 *
 */
class CsvImportHandler
{

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @param Data $helper
     */
    public function __construct(
        Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * @param $subject
     * @param $result
     * @return mixed
     */
    public function afterGetRequiredCsvFields($subject, $result)
    {

        if (!$this->helper->isEnabled()) {
            return $result;
        }

        return array_merge($result, [
            8 => __('From Subtotal'),
            9 => __('To Subtotal')
        ]);
    }
}
