<?php

namespace FiloBlu\ThresholdTaxes\Plugin\Model\Calculation\Rate;

use FiloBlu\ThresholdTaxes\Helper\Data;
use Magento\Tax\Api\Data\TaxRateInterface;

/**
 *
 */
class Converter
{


    /**
     * @param \Magento\Tax\Model\Calculation\Rate\Converter $subject
     * @param TaxRateInterface $taxRate
     * @param $formData
     * @return TaxRateInterface
     */
    public function aroundPopulateTaxRateData(
        \Magento\Tax\Model\Calculation\Rate\Converter $subject,
        $proceed,
        $formData
    ) {
        $taxRate = $proceed($formData);
        $taxRate->setFromTotal($formData['from_total'] ?? Data::DEFAULT_FROM_TOTAL);
        $taxRate->setToTotal($formData['to_total'] ?? Data::DEFAULT_TO_TOTAL);
        return $taxRate;
    }

    /**
     * @param \Magento\Tax\Model\Calculation\Rate\Converter $subject
     * @param $taxRateFormData
     * @param TaxRateInterface $taxRate
     * @param bool $returnNumericLogic
     * @return mixed
     */
    public function aroundCreateArrayFromServiceObject(
        \Magento\Tax\Model\Calculation\Rate\Converter $subject,
        $proceed,
        TaxRateInterface $taxRate,
        $returnNumericLogic = false
    ) {
        $taxRateFormData = $proceed($taxRate, $returnNumericLogic);
        $taxRateFormData['from_total'] = $taxRate->getFromTotal();
        $taxRateFormData['to_total'] = $taxRate->getToTotal();

        return $taxRateFormData;
    }
}
