<?php

declare(strict_types=1);

namespace FiloBlu\ThresholdTaxes\Model;

use FiloBlu\ThresholdTaxes\Helper\Data;
use Magento\Tax\Api\Data\TaxRateInterface as TaxRate;

/**
 *
 */
class TaxRateCollection extends \Magento\Tax\Model\TaxRateCollection
{

    /**
     * Creates a collection item that represents a tax rate for the tax rates grid.
     *
     * @param TaxRate $taxRate Input data for creating the item.
     * @return \Magento\Framework\DataObject Collection item that represents a tax rate
     */
    protected function createTaxRateCollectionItem(TaxRate $taxRate)
    {
        $collectionItem = parent::createTaxRateCollectionItem($taxRate);

        $collectionItem->setFromTotal($taxRate->getFromTotal() ?? Data::DEFAULT_FROM_TOTAL);
        $collectionItem->setToTotal($taxRate->getToTotal() ?? Data::DEFAULT_TO_TOTAL);

        return $collectionItem;
    }
}
