<?php

namespace FiloBlu\ThresholdTaxes\Model;

use Magento\Framework\App\ObjectManager;

/**
 *
 */
class Calculation extends \Magento\Tax\Model\Calculation
{

    const THRESHOLD_TAX_APPLY = 'THRESHOLD_TAX_APPLY';

    /**
     * @var \FiloBlu\ThresholdTaxes\Model\QuoteLocator|mixed
     */
    private $quoteLocator;

    /**
     * Get cache key value for specific tax rate request
     *
     * @param \Magento\Framework\DataObject $request
     * @return  string
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function _getRequestCacheKey($request)
    {
        $cacheKey = parent::_getRequestCacheKey($request);

        if (!$this->_registry->registry(self::THRESHOLD_TAX_APPLY)) {
            return $cacheKey;
        }

        $quote = $this->getQuote();

        if ($quote && $quote->hasItems()) {
            $cacheKey .= '|' . $quote->getShippingAddress()->getSubtotalWithDiscount();
        }

        return $cacheKey;
    }

    /**
     * @return \Magento\Quote\Api\Data\CartInterface|\Magento\Quote\Model\Quote
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getQuote()
    {
        return $this->getQuoteLocator()->getQuote();
    }

    /**
     * @return \FiloBlu\ThresholdTaxes\Model\QuoteLocator|mixed
     */
    public function getQuoteLocator()
    {
        if (!$this->quoteLocator) {
            $this->quoteLocator = ObjectManager::getInstance()->get(
                QuoteLocator::class
            );
        }
        return $this->quoteLocator;
    }
}
