<?php

declare(strict_types=1);

namespace FiloBlu\ThresholdTaxes\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;

/**
 *
 */
class Data extends AbstractHelper
{
    /** @var string */
    const FILOBLU_THRESHOLD_TAXES_ENABLED = 'filoblu_threshold_taxes/general/taxes';
    /** @var float */
    const DEFAULT_FROM_TOTAL = 0.0;
    /** @var float */
    const DEFAULT_TO_TOTAL = 999999999.00;

    /**
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig
    ) {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(self::FILOBLU_THRESHOLD_TAXES_ENABLED);
    }
}
