<?php

namespace FiloBlu\ThresholdTaxes\Block\Adminhtml\Rate;

use FiloBlu\ThresholdTaxes\Helper\Data;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Tax\Controller\RegistryConstants;

/**
 *
 */
class Form extends \Magento\Tax\Block\Adminhtml\Rate\Form
{

    /**
     * Prepare form before rendering HTML.
     *
     * @return $this
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function _prepareForm()
    {
        parent::_prepareForm();

        $taxRateId = $this->_coreRegistry->registry(RegistryConstants::CURRENT_TAX_RATE_ID);

        try {
            if ($taxRateId) {
                $taxRateDataObject = $this->_taxRateRepository->get($taxRateId);
            }
            // phpcs:ignore Magento2.CodeAnalysis.EmptyBlock
        } catch (NoSuchEntityException $e) {
            //tax rate not found//
        }

        $sessionFormValues = (array)$this->_coreRegistry->registry(RegistryConstants::CURRENT_TAX_RATE_FORM_DATA);
        $formData = isset($taxRateDataObject) ? $this->_taxRateConverter->createArrayFromServiceObject(
            $taxRateDataObject
        ) : [];
        $formData = array_merge($formData, $sessionFormValues);

        $fieldset = $this->getForm()->getElement('base_fieldset');

        if ($fieldset === null) {
            return $this;
        }
        $fieldset->addField(
            'from_total',
            'text',
            [
                'name'     => 'from_total',
                'label'    => __('From Subtotal'),
                'title'    => __('From Subtotal'),
                'required' => false,
                'class'    => 'validate-not-negative-number',
                'value'    => $formData['from_total'] ?? Data::DEFAULT_FROM_TOTAL
            ]
        );

        $fieldset->addField(
            'to_total',
            'text',
            [
                'name'     => 'to_total',
                'label'    => __('To Subtotal'),
                'title'    => __('To Subtotal'),
                'required' => false,
                'class'    => 'validate-not-negative-number',
                'value'    => $formData['to_total'] ?? Data::DEFAULT_TO_TOTAL,
                'note'     => __('Set both from and to totals to 0 to disable threshold condition')
            ]
        );

        return $this;
    }
}
