define([
    'mage/utils/wrapper',
    'Magento_Checkout/js/checkout-data',
    'FiloBlu_Storelocator/js/model/address-converter',
    'Magento_Checkout/js/action/select-shipping-address',
    'Magento_Checkout/js/model/quote'
], function (wrapper, checkoutData, addressConverter,  selectShippingAddress, quote, shippingMethodData) {
    'use strict';

    return function (target) {

        var applyShippingAddressMixin = wrapper.wrap(target.applyShippingAddress, function(originalAction){

          if (!window.checkoutConfig.pickup_in_store.enabled) {
            return originalAction();
          }
          
          var original = originalAction();
          var shippingAddress = checkoutData.getShippingAddressFromData();

          if (shippingAddress && checkoutData.getSelectedShippingAddress() == "pickup-address") {
              var newShippingAddressData = addressConverter.formAddressDataToQuoteAddress(shippingAddress);
              selectShippingAddress(newShippingAddressData);
          }

          return original;
        });

        // var resolveShippingRatesMixin = wrapper.wrap(target.resolveShippingRates, function(originalAction){
        //
        //   shippingMethodData(arguments[1]);
        //   var original = originalAction();
        //
        //   return original;
        // });

        target.applyShippingAddress = applyShippingAddressMixin;
        // target.resolveShippingRates = resolveShippingRatesMixin;

        return target;
    };
});
