<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Plugin;

use FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface;
use FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterfaceFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderSearchResultInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

/**
 *
 */
class AddPickupInStoreInformation
{
    /**
     * @var \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterfaceFactory
     */
    private $pickupInStoreInformationFactory;

    /**
     * @param \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterfaceFactory $pickupInStoreInformationFactory
     */
    public function __construct(PickupInStoreInformationInterfaceFactory $pickupInStoreInformationFactory)
    {
        $this->pickupInStoreInformationFactory = $pickupInStoreInformationFactory;
    }

    /**
     * @param \Magento\Sales\Api\OrderRepositoryInterface $subject
     * @param \Magento\Sales\Api\Data\OrderInterface $order
     * @return \Magento\Sales\Api\Data\OrderInterface
     */
    public function afterGet(OrderRepositoryInterface $subject, OrderInterface $order): OrderInterface
    {
        return $this->addInformation($order);
    }

    /**
     * @param \Magento\Sales\Api\Data\OrderInterface $order
     * @return \Magento\Sales\Api\Data\OrderInterface
     */
    public function addInformation(OrderInterface $order): OrderInterface
    {
        if (!$order->getExtensionAttributes())
        {
            return $order;
        }

        $information = $this->pickupInStoreInformationFactory->create([
            'data' => [
                PickupInStoreInformationInterface::ID                   => $order->getPickupInStoreId(),
                PickupInStoreInformationInterface::CODE                 => $order->getPickupInStoreCode(),
                PickupInStoreInformationInterface::HASH                 => $order->getPickupInStoreHash(),
                PickupInStoreInformationInterface::EMAIL                => $order->getPickupInStoreEmail(),
                PickupInStoreInformationInterface::CONFIRM_DATE         => $order->getPickupInStoreConfirmDate(),
                PickupInStoreInformationInterface::CONFIRM_RECEIVE_DATE => $order->getPickupInStoreConfirmReceivedDate(),
                PickupInStoreInformationInterface::EMAIL_SEND_DATE      => $order->getPickupInStoreEmailSendDate()
            ]
        ]);

        $order->getExtensionAttributes()->setFilobluPickupInStore($information);

        return $order;
    }

    /**
     * @param OrderRepositoryInterface $subject
     * @param OrderSearchResultInterface $searchResult
     * @return OrderSearchResultInterface
     */
    public function afterGetList(OrderRepositoryInterface $subject, OrderSearchResultInterface $searchResult): OrderSearchResultInterface {
        foreach ($searchResult->getItems() as $order)
        {
            $this->addInformation($order);
        }

        return $searchResult;
    }

}