<?php

namespace FiloBlu\Storelocator\Model;

use FiloBlu\Storelocator\Model\ResourceModel\Tags\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException as CoreException;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Tags extends AbstractModel
{

    protected $tagsCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @param ResourceModel\Tags\CollectionFactory $tagsCollectionFactory
     * @param StoreManagerInterface $_storeManager
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory $tagsCollectionFactory,
        StoreManagerInterface $_storeManager,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->tagsCollectionFactory = $tagsCollectionFactory;
        $this->_storeManager = $_storeManager;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @return string[]
     */
    public function getAvailableStatuses()
    {
        return [
            0 => 'Disabled',
            1 => 'Enabled'
        ];
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getAllAvailableTags()
    {
        $collection = $this->getAllTags();

        $collection->getSelect()->join(
            ['related' => $collection->getTable('filoblu_storelocator_store_tag')],
            'related.tag_id=main_table.tag_id', ['main_table.tag_id', 'main_table.image', 'main_table.description']
        );

        $collection->getSelect()->group(['tag_id', 'image', 'description']);

        foreach ($collection as $tag) {
            if ($tag->getImage()) {
                $tag->setImageUrl(
                    $this->_storeManager->getStore()->getBaseUrl(
                        UrlInterface::URL_TYPE_MEDIA
                    ) . 'filoblu/storelocator/stores/image/' . $tag->getImage()
                );
            }
        }

        return $collection;
    }

    /**
     * @return mixed
     */
    public function getAllTags()
    {
        $collection = $this->tagsCollectionFactory->create();
        $collection->addFieldToFilter('enabled', ['eq' => 1]);

        return $collection;
    }

    /**
     * @param $name
     * @return mixed
     */
    public function loadByTagName($name)
    {
        $collection = $this->tagsCollectionFactory->create();

        $collection->addFieldToFilter('name', $name);
        return $collection->getFirstItem();
    }

    /**
     * Initialize resource model
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\Tags::class);
    }

}
