<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Model;

use FiloBlu\Storelocator\Api\Data\StoreInterface;
use FiloBlu\Storelocator\Api\StoreServiceInterface;
use Magento\Framework\Exception\NotFoundException;

/**
 *
 */
class StoreService implements StoreServiceInterface{
    /**
     * @var \FiloBlu\Storelocator\Model\StoreRepository
     */
    private $storeRepository;

    /**
     * @param \FiloBlu\Storelocator\Model\StoreRepository $storeRepository
     */
    public function __construct(StoreRepository $storeRepository)
    {
        $this->storeRepository = $storeRepository;
    }

    /**
     * @param string $code
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     * @throws \Magento\Framework\Exception\NotFoundException
     */
    public function getByCode($code): StoreInterface
    {
        $store = $this->storeRepository->getByStoreCode($code);

        if($store === null){
            throw new NotFoundException(__('No store found for code %1', $code));
        }

        return $store;
    }
}