<?php

namespace FiloBlu\Storelocator\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;

/**
 *
 */
class StoreImage extends AbstractModel implements IdentityInterface
{
    const CACHE_TAG = 'filoblu_storelocator_storeimage';

    protected $_cacheTag = 'filoblu_storelocator_storeimage';

    protected $_eventPrefix = 'filoblu_storelocator_storeimage';

    /**
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @return array
     */
    public function getDefaultValues()
    {
        return [];
    }

    /**
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\StoreImage::class);
    }
}
