<?php

namespace FiloBlu\Storelocator\Model\Plugin\Rma\Item\Attribute\Source;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Store\Model\StoreManagerInterface;

class Status
{
    /**
     * @var Data
     */
    protected $helper;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Data $helper
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Data $helper,
        StoreManagerInterface $storeManager
    ) {
        $this->helper = $helper;
        $this->storeManager = $storeManager;
    }

    /**
     * @param \Magento\Rma\Model\Item\Attribute\Source\Status $subject
     * @param $result
     * @param $status
     * @return bool|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function afterCheckStatus(\Magento\Rma\Model\Item\Attribute\Source\Status $subject, $result, $status = null)
    {
        $storeId = $this->storeManager->getStore()->getId();

        if (!$this->helper->getReturnToStoreEnabled($storeId)) {
            return $result;
        }

        if ($status && $status == \FiloBlu\Storelocator\Model\Plugin\Rma\Source\Status::STATE_RECEIVED_IN_STORE) {
            return true;
        }

        return $result;
    }
}