<?php

namespace FiloBlu\Storelocator\Model\Plugin\Checkout;

use FiloBlu\Storelocator\Helper\Data;
use FiloBlu\Storelocator\Model\StoreRepository;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Api\Data\AddressInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Framework\Exception\InputException;
use Magento\Checkout\Model\ShippingInformationManagement as ShippingManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;

/**
 *
 */
class ShippingInformationManagement
{
    /**
     * @var \FiloBlu\Storelocator\Helper\Data
     */
    private $helper;
    /**
     * @var QuoteRepository
     */
    private $quoteRepository;
    /**
     * @var \FiloBlu\Storelocator\Model\StoreRepository
     */
    private $storeRepository;

    /**
     * @param \FiloBlu\Storelocator\Helper\Data $helper
     * @param \Magento\Quote\Model\QuoteRepository $quoteRepository
     * @param \FiloBlu\Storelocator\Model\StoreRepository $storeRepository
     */
    public function __construct(
        Data $helper,
        QuoteRepository $quoteRepository,
        StoreRepository $storeRepository
    ) {
        $this->helper = $helper;
        $this->quoteRepository = $quoteRepository;
        $this->storeRepository = $storeRepository;
    }

    /**
     * @param ShippingManagement $subject
     * @param $cartId
     * @param ShippingInformationInterface $addressInformation
     * @return void
     * @throws InputException
     * @throws NoSuchEntityException
     */
    public function beforeSaveAddressInformation(
        ShippingManagement $subject,
        $cartId,
        ShippingInformationInterface $addressInformation
    ) {
        if ($this->helper->getConfig('carriers/pickupinstore/active')) {
            $quote = $this->quoteRepository->getActive($cartId);

            $shippingAddress = $addressInformation->getShippingAddress();
            $extAttributes = $shippingAddress->getExtensionAttributes();
            $methodCode = $addressInformation->getShippingMethodCode();

            if ($methodCode === 'pickupinstore') {

                $this->fillStoreProperties($shippingAddress);
                $quote->setPickupInStoreId((int)$extAttributes->getSelectedStoreId());
                $quote->setPickupInStoreCode($extAttributes->getSelectedStoreCode());

                $quote->setPickupInStoreEmail(
                    $extAttributes->getSelectedStoreEmail() ? $extAttributes->getSelectedStoreEmail(
                    ) : $shippingAddress->getEmail()
                );
                return;
            }

            $quote->setPickupInStoreId(null);
            $quote->setPickupInStoreCode(null);
            $quote->setPickupInStoreEmail(null);
        }
    }

    /**
     * @param \Magento\Quote\Api\Data\AddressInterface $shippingAddress
     * @return void
     * @throws \Magento\Framework\Exception\InputException
     */
    public function fillStoreProperties(AddressInterface $shippingAddress)
    {
        $extensionAttribute = $shippingAddress->getExtensionAttributes();

        if(!$extensionAttribute){
            throw new InputException(__('Select a store for pick up'));
        }

        $storeId = (int)$extensionAttribute->getSelectedStoreId();

        if($storeId === -1) {
            return;
        }

        if($storeId > 0)
        {
            $extensionAttribute->setSelectedStoreCode($this->storeRepository->getCodeById($storeId));
            return;
        }

        $storeCode = $extensionAttribute->getSelectedStoreCode();

        if($storeCode){
            $extensionAttribute->setSelectedStoreId($this->storeRepository->getIdFromCode($storeCode));
            return;
        }

        throw new InputException(__('Select a store for pick up'));
    }
}
