<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Model;


use FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface;
use Magento\Framework\DataObject;

/**
 *
 */
class PickupInStoreInformation extends DataObject implements PickupInStoreInformationInterface
{

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->_getData(self::ID);
    }

    /**
     * @return string|null
     */
    public function getCode()
    {
        return $this->_getData(self::CODE);
    }

    /**
     * @return string|null
     */
    public function getHash()
    {
        return $this->_getData(self::HASH);
    }

    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->_getData(self::EMAIL);
    }

    /**
     * @return string|null
     */
    public function getConfirmReceivedDate()
    {
        return $this->_getData(self::CONFIRM_RECEIVE_DATE);
    }

    /**
     * @return string|null
     */
    public function getEmailSendDate()
    {
        return $this->_getData(self::EMAIL_SEND_DATE);
    }

    /**
     * @return string|null
     */
    public function getConfirmDate()
    {
        return $this->_getData(self::CONFIRM_DATE);
    }

    /**
     * @param int|null $id
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setId($id)
    {
        return $this->setData(self::ID, $id);
    }

    /**
     * @param string|null $code
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setCode($code)
    {
        return $this->setData(self::CODE, $code);
    }

    /**
     * @param string|null $hash
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setHash($hash)
    {
        return $this->setData(self::HASH, $hash);
    }

    /**
     * @param string|null $email
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setEmail($email)
    {
        return $this->setData(self::EMAIL, $email);
    }

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setEmailSendDate($date)
    {
        return $this->setData(self::EMAIL_SEND_DATE, $date);
    }

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setConfirmDate($date)
    {
        return $this->setData(self::CONFIRM_DATE, $date);
    }

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setConfirmReceivedDate($date)
    {
        return $this->setData(self::CONFIRM_RECEIVE_DATE, $date);
    }
}