<?php

namespace FiloBlu\Storelocator\Controller\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Magento\Rma\Model\Rma;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class ConfirmReceived extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \FiloBlu\Storelocator\Helper\Data
     */
    protected $helper;

    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helper
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helper,
        Registry $registry,
        StoreManagerInterface $storeManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->helper = $helper;
        $this->registry = $registry;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     *
     * @return \Magento\Framework\View\Result\Page|void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $hash = $this->getRequest()->getParam('hash');
        $storeId = $this->storeManager->getStore()->getId();

        $isPickupInStoreEnabled = $this->helper->getPickupInStoreEnabled($storeId);
        $isReturnInStoreEnabled = $this->helper->getReturnToStoreEnabled($storeId);

        if ((!$isPickupInStoreEnabled && !$isReturnInStoreEnabled) || !$hash) {
            $this->_forward('noRoute');
            return;
        }

        // check if is rma or order request
        $order = $this->getOrder($hash);
        $rma = $this->getRma($hash);

        if ($rma && $isReturnInStoreEnabled)
        {
            $order = $rma->getOrder();

            if ($order->getId())
            {
                $this->registry->register('pickupinstore_order_confirm_received', $order);
                $resultPage = $this->resultPageFactory->create();
                $resultPage->getConfig()
                           ->getTitle()
                           ->set(
                               __(
                                   'PickUp In Store - Confirmation of receipt of the package for order '
                               ) . $order->getIncrementId()
                           )
                ;
                return $resultPage;
            }
        }

        if ($order)
        {
            $this->registry->register('pickupinstore_order_confirm_received', $order);
            $resultPage = $this->resultPageFactory->create();
            $resultPage->getConfig()
                       ->getTitle()
                       ->set(
                           __(
                               'PickUp In Store - Confirmation of receipt of the package for order '
                           ) . $order->getIncrementId()
                       )
            ;

            return $resultPage;
        }


        $this->_forward('noRoute');
    }

    /**
     * @param string|null $hash
     * @return \Magento\Sales\Api\Data\OrderInterface|null
     */
    public function getOrder($hash){

        try
        {
            return $this->helper->getOrderByHash($hash);
        } catch (NoSuchEntityException $e)
        {
            return null;
        }

    }

    /**
     * @param string|null $hash
     * @return Rma|null
     */
    public function getRma($hash){
        try
        {
            return $this->helper->getRmaByHash($hash);
        } catch (NoSuchEntityException $e)
        {
            return null;
        }
    }
}
