<?php

namespace FiloBlu\Storelocator\Controller\Index;

use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 *
 */
class StoreDetailsById extends Action
{
    /**
     * @var \FiloBlu\Storelocator\Model\StoresFactory
     */
    protected $storeFactory;
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private $resultJsonFactory;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \FiloBlu\Storelocator\Model\StoresFactory $storeFactory
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        StoresFactory $storeFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->storeFactory = $storeFactory;
    }

    /**
     * @return \Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface|null
     */
    public function execute()
    {
        $params = $this->getRequest()->getParams();

        if ($params['ajax'] == 1 && $params['store_id'] && $this->getRequest()->isXmlHttpRequest()) {
            $resultJson = $this->resultJsonFactory->create();

            $model = $this->storeFactory->create()->load($params['store_id']);
            $resultJson->setData($model->getData());

            return $resultJson;
        }

        return null;
    }
}
