<?php

namespace FiloBlu\Storelocator\Controller\Index;

use FiloBlu\Storelocator\Helper\Data;
use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

/**
 *
 */
class Shop extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $pageFactory;

    /** @var \FiloBlu\Storelocator\Helper\Data */
    protected $helper;
    /**
     * @var \FiloBlu\Storelocator\Model\StoresFactory
     */
    protected $storesFactory;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $pageFactory
     * @param \FiloBlu\Storelocator\Helper\Data $helper
     * @param \FiloBlu\Storelocator\Model\StoresFactory $storesFactory
     */
    public function __construct(
        PageFactory $pageFactory,
        Data $helper,
        StoresFactory $storesFactory,
        Context $context
    ) {
        $this->pageFactory = $pageFactory;
        $this->helper = $helper;
        $this->storesFactory = $storesFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\Controller\ResultInterface|\Magento\Framework\View\Result\Page|void
     */
    public function execute()
    {
        $shopId = $this->getRequest()->getParam('id');

        $shop = $this->storesFactory->create()->load($shopId);

        if ($shop->getData('enabled')) {
            $resultPage = $this->pageFactory->create();
            $resultPage->getConfig()->getTitle()->set($shop->getTitle());
            return $resultPage;
        }

        $this->_forward('noRoute');
    }
}
