<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Block\PickUpInStore;


/**
 *
 */
class Template extends \Magento\Framework\View\Element\Template
{

    /**
     * @return string
     */
    public function getOrderConfirmedReceivedLink()
    {
        return $this->_urlBuilder->getUrl(
            'storelocator/pickupinstore/confirmreceived', [
                'hash'   => $this->getDataByPath('order_data/pickup_in_store_hash'),
                '_scope' => $this->getDataByPath('order_data/store_id')
            ]
        );
    }

    /**
     * @return string
     */
    public function getOrderConfirmedLink()
    {
        return $this->_urlBuilder->getUrl(
            'storelocator/pickupinstore/confirm', [
                'hash'   => $this->getDataByPath('order_data/pickup_in_store_hash'),
                '_scope' => $this->getDataByPath('order_data/store_id')
            ]
        );
    }

    /**
     * @return string
     */
    public function getRmaConfirmReceivedLink()
    {
        return $this->_urlBuilder->getUrl(
            'storelocator/pickupinstore/rmareceived', [
                'hash' => $this->getDataByPath('rma_data/return_to_store_hash'),
                '_scope' => $this->getDataByPath('rma_data/store_id')
            ]
        );
    }

    /**
     * @return string
     */
    public function getRmaRefusedLink()
    {
        return $this->_urlBuilder->getUrl(
            'storelocator/pickupinstore/rmarefused', [
                'hash' => $this->getDataByPath('rma_data/return_to_store_hash'),
                '_scope' => $this->getDataByPath('rma_data/store_id')

            ]
        );
    }

    /**
     * @return string
     */
    public function getRmaReceivedLink()
    {
        return $this->_urlBuilder->getUrl(
            'storelocator/pickupinstore/rmareceived', [
                'hash' => $this->getDataByPath('rma_data/return_to_store_hash'),
                '_scope' => $this->getDataByPath('rma_data/store_id')
            ]
        );
    }

}
