<?php

namespace FiloBlu\Storelocator\Block\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

/**
 *
 */
class Confirm extends Template
{
	protected $helper;
	protected $registry;
	protected $storeManager;
	protected $request;

	/**
	 * @param Context $context
	 * @param Data $helper
	 * @param Registry $registry
	 * @param Http $request
	 */
	public function __construct(
		Context  $context,
		Data     $helper,
		Registry $registry,
		Http     $request
	)
	{
		parent::__construct($context);
		$this->helper = $helper;
		$this->registry = $registry;
		$this->storeManager = $context->getStoreManager();
		$this->request = $request;
	}

	/**
	 * @return bool
	 */
	public function isAlreadyConfirmed()
	{
		return $this->registry->registry('pickupinstore_order_confirm')->getPickupInStoreConfirmDate() != null;
	}

	/**
	 * @return bool
	 */
	public function isNotAlreadyReceived()
	{
		return $this->registry->registry('pickupinstore_order_confirm')->getPickupInStoreConfirmReceivedDate() == null;
	}

	/**
	 * @return string
	 * @throws NoSuchEntityException
	 */
	public function getBaseUrl()
	{
		return $this->storeManager->getStore()->getBaseUrl();
	}

	/**
	 * @return string
	 */
	public function getParams()
	{
		if ($params = $this->getRequest()->getParams()) {
			$incrementId = $params['increment_id'] ?? '';
			$hash = $params['hash'] ?? '';
			return 'increment_id=' . $incrementId . '&hash=' . $hash;
		}
		return '';
	}
}
