<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Api\Data;

/**
 *
 */
interface StoreInterface {
    /** @var string */
    const STORE_ID = 'store_id';
    /** @var string */
    const ENABLED = 'enabled';
    /** @var string */
    const TITLE = 'title';
    /** @var string */
    const IMAGE = 'image';
    /** @var string */
    const LATITUDE = 'latitude';
    /** @var string */
    const LONGITUDE = 'longitude';
    /** @var string */
    const STORE_IDS = 'store_ids';
    /** @var string */
    const STREET = 'street';
    /** @var string */
    const POSTCODE = 'postcode';
    /** @var string */
    const CITY = 'city';
    /** @var string */
    const COUNTRY = 'country';
    /** @var string */
    const PHONE_1 = 'phone_1';
    /** @var string */
    const PHONE_2 = 'phone_2';
    /** @var string */
    const FAX = 'fax';
    /** @var string */
    const EMAIL = 'email';
    /** @var string */
    const WEBSITE_URL = 'website_url';
    /** @var string */
    const ADDITIONAL_TEXT = 'additional_text';
    /** @var string */
    const MARKER_IMAGE = 'marker_image';
    /** @var string */
    const GMB_CAT = 'gmb_cat';
    /** @var string */
    const GMB_LANGUAGE_CODE = 'gmb_language_code';
    /** @var string */
    const GMB_LOCATION_NAME = 'gmb_location_name';
    /** @var string */
    const REGION = 'region';
    /** @var string */
    const REGION_ID = 'region_id';
    /** @var string */
    const IS_ENABLED_FOR_PICKUPINSTORE = 'is_enabled_for_pickup_in_store';
    /** @var string */
    const URL_KEY = 'url_key';
    /** @var string */
    const STORE_CODE = 'store_code';
    /** @var string */
    const IS_ENABLED_SHOP_DETAILS = 'is_enabled_shop_details';
    /** @var string */
    const STORE_EXTERNAL_IFRAME_APPOINTMENT = 'store_external_iframe_appointment';
    /** @var string */
    const ADDITIONAL_TEXT_2 = 'additional_text_2';
    /** @var string */
    const STORE_FILENAME_PREFIX = 'store_filename_prefix';
    /** @var string */
    const IS_ENABLED_FOR_RETURN_IN_STORE = 'is_enabled_for_return_in_store';
    /** @var string */
    const LAST_UPDATE = 'last_update';

    /**
     * @return int
     */
    public function getStoreId();

    /**
     * @return bool
     */
    public function getEnabled();

    /**
     * @return string
     */
    public function getTitle();

    /**
     * @return string
     */
    public function getImage();

    /**
     * @return float
     */
    public function getLatitude();

    /**
     * @return float
     */
    public function getLongitude();

    /**
     * @return int[]
     */
    public function getStoreIds();

    /**
     * @return string
     */
    public function getStreet();

    /**
     * @return string
     */
    public function getPostcode();

    /**
     * @return string
     */
    public function getCity();

    /**
     * @return string
     */
    public function getCountry();

    /**
     * @return string
     */
    public function getPhone1();

    /**
     * @return string
     */
    public function getPhone2();

    /**
     * @return string
     */
    public function getFax();

    /**
     * @return string
     */
    public function getEmail();

    /**
     * @return string
     */
    public function getWebsiteUrl();

    /**
     * @return string
     */
    public function getAdditionalText();

    /**
     * @return string
     */
    public function getMarkerImage();

    /**
     * @return string
     */
    public function getGmbCat();

    /**
     * @return string
     */
    public function getGmbLanguageCode();

    /**
     * @return string
     */
    public function getGmbLocationName();

    /**
     * @return string
     */
    public function getRegion();

    /**
     * @return string
     */
    public function getRegionId();

    /**
     * @return bool
     */
    public function getIsEnabledForPickupInStore();

    /**
     * @return string
     */
    public function getUrlKey();

    /**
     * @return string
     */
    public function getStoreCode();

    /**
     * @return bool
     */
    public function getIsEnabledShopDetails();

    /**
     * @return string
     */
    public function getStoreExternalIframeAppointment();

    /**
     * @return string
     */
    public function getAdditionalText2();

    /**
     * @return string
     */
    public function getStoreFilenamePrefix();

    /**
     * @return bool
     */
    public function getIsEnabledForReturnInStore();

    /**
     * @return string
     */
    public function getLastUpdate();

    /**
     * @param int $storeId
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setStoreId($storeId);

    /**
     * @param bool $enabled
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setEnabled($enabled);

    /**
     * @param string $title
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setTitle($title);

    /**
     * @param string $image
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setImage($image);

    /**
     * @param float $latitude
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setLatitude($latitude);

    /**
     * @param float $longitude
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setLongitude($longitude);

    /**
     * @param int[] $storeIds
     * @return mixed
     */
    public function setStoreIds($storeIds);

    /**
     * @param string $street
     * @return mixed
     */
    public function setStreet($street);

    /**
     * @param string $postcode
     * @return mixed
     */
    public function setPostcode($postcode);

    /**
     * @param string $city
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setCity($city);

    /**
     * @param string $country
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setCountry($country);

    /**
     * @param string $phone1
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setPhone1($phone1);

    /**
     * @param string $phone2
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setPhone2($phone2);

    /**
     * @param string $fax
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setFax($fax);

    /**
     * @param string $email
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setEmail($email);

    /**
     * @param string $websiteUrl
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setWebsiteUrl($websiteUrl);

    /**
     * @param string $additionalText
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setAdditionalText($additionalText);

    /**
     * @param string $markerImage
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setMarkerImage($markerImage);

    /**
     * @param string $gmbCat
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setGmbCat($gmbCat);

    /**
     * @param string $gmbLanguageCode
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setGmbLanguageCode($gmbLanguageCode);

    /**
     * @param string $gmbLocationName
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setGmbLocationName($gmbLocationName);

    /**
     * @param string $region
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setRegion($region);

    /**
     * @param int $regionId
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setRegionId($regionId);

    /**
     * @param bool $isEnabledForPickupInStore
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setIsEnabledForPickupInStore($isEnabledForPickupInStore);

    /**
     * @param string $urlKey
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setUrlKey($urlKey);

    /**
     * @param string $storeCode
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setStoreCode($storeCode);

    /**
     * @param bool $isEnabledShopDetails
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setIsEnabledShopDetails($isEnabledShopDetails);

    /**
     * @param string $storeExternalIframeAppointment
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setStoreExternalIframeAppointment($storeExternalIframeAppointment);

    /**
     * @param string $additionalText2
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setAdditionalText2($additionalText2);

    /**
     * @param string $storeFilenamePrefix
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setStoreFilenamePrefix($storeFilenamePrefix);

    /**
     * @param bool $isEnabledForReturnInStore
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setIsEnabledForReturnInStore($isEnabledForReturnInStore);

    /**
     * @param string $lastUpdate
     * @return \FiloBlu\Storelocator\Api\Data\StoreInterface
     */
    public function setLastUpdate($lastUpdate);
}