<?php

declare(strict_types=1);


namespace FiloBlu\Storelocator\Api\Data;

/**
 *
 */
interface PickupInStoreInformationInterface
{
    /** @var string  */
    const ID = 'id';
    /** @var string  */
    const CODE ='code';
    /** @var string  */
    const HASH = 'hash';
    /** @var string  */
    const EMAIL = 'email';
    /** @var string  */
    const CONFIRM_RECEIVE_DATE = 'confirm_received_date';
    /** @var string  */
    const EMAIL_SEND_DATE = 'email_send_date';
    /** @var string  */
    const CONFIRM_DATE = 'confirm_date';

    /**
     * @return int|null
     */
    public function getId();

    /**
     * @return string|null
     */
    public function getCode();

    /**
     * @return string|null
     */
    public function getHash();

    /**
     * @return string|null
     */
    public function getEmail();

    /**
     * @return string|null
     */
    public function getConfirmReceivedDate();

    /**
     * @return string|null
     */
    public function getEmailSendDate();

    /**
     * @return string|null
     */
    public function getConfirmDate();

    /**
     * @param int|null $id
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setId($id);

    /**
     * @param string|null $code
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setCode($code);

    /**
     * @param string|null $hash
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setHash($hash);

    /**
     * @param string|null $email
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setEmail($email);

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setEmailSendDate($date);

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setConfirmDate($date);

    /**
     * @param string|null $date
     * @return \FiloBlu\Storelocator\Api\Data\PickupInStoreInformationInterface
     */
    public function setConfirmReceivedDate($date);
}