define([
    'jquery'
], function ($) {
    'use strict';

    return function (config) {
        var defaults = {
            newStoreCenter: {
                lat: 41.068179,
                lng: 14.331737
            },
            zoom: 4,
            minZoom: 3,
            maxZoom: 20,
            mapContainerId: 'map',
            mapTypeId: 'roadmap',
            zoomControl: true,
            mapTypeControl: true,
            streetViewControl: true,
            rotateControl: true,
            scaleControl: true,
            fullscreenControl: true,
            gmapSearchAutocompleteId: 'gmapSearch',
            gmapSearchAutocompleteZoom: 17

        };

        config = $.extend(defaults, config);

        // Thanks to Bluefoot that includes google maps on every page async
        var GoogleMapVar = $.extend(true, {}, google);

        var map = new GoogleMapVar.maps.Map(document.getElementById(config.mapContainerId), config);

        var input = document.getElementById(config.gmapSearchAutocompleteId);
        var autocomplete = new GoogleMapVar.maps.places.Autocomplete(input);

        autocomplete.bindTo('bounds', map);

        autocomplete.addListener('place_changed', function () {
            var place = autocomplete.getPlace();
            if (!place.geometry) {
                window.alert("Autocomplete's returned place contains no geometry");
                return;
            }

            // If the place has a geometry, then present it on a map.
            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17);
            }
        });

        if (config.center.lat && config.center.lng) {
            var marker = new GoogleMapVar.maps.Marker({
                position: config.center,
                draggable: true,
                map: map
//                        icon: config.gmapMarkersMarkerImage,
            });

            GoogleMapVar.maps.event.addListener(marker, 'dragend', function ()
            {
                var latLng = marker.getPosition();
                $("#storelocator_store_latitude").val(latLng.lat());
                $("#storelocator_store_longitude").val(latLng.lng());

            });

            map.setCenter(config.center);
            map.setZoom(15);
        } else {

            var markerAdded = false;
            map.setCenter(config.newStoreCenter);
            map.setZoom(4);

            GoogleMapVar.maps.event.addListener(map, 'click', function (e) {
                if (!markerAdded) {
                    markerAdded = true;
                    var latLng = {
                        lat: e.latLng.lat(),
                        lng: e.latLng.lng()
                    };

                    var marker = new GoogleMapVar.maps.Marker({
                        position: latLng,
                        draggable: true,
                        map: map
                    });

                    $("#storelocator_store_latitude").val(e.latLng.lat());
                    $("#storelocator_store_longitude").val(e.latLng.lng());

                    GoogleMapVar.maps.event.addListener(marker, 'dragend', function ()
                    {
                        var latLng = marker.getPosition();
                        $("#storelocator_store_latitude").val(latLng.lat());
                        $("#storelocator_store_longitude").val(latLng.lng());

                    });

//                map.panTo(latLng);
                }
            });
        }
    };
});