<?php

namespace FiloBlu\Storelocator\Setup;

use FiloBlu\Storelocator\Model\EventsRepository;
use FiloBlu\Storelocator\Model\StoreRepository;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;
use Zend_Db_Exception;

/**
 *
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws Zend_Db_Exception
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {

            //code to upgrade to 1.0.1
            // add fulltext index to permitt fulltext search in grid
            if ($setup->tableExists('filoblu_storelocator_stores')) {
                $setup->getConnection()->addIndex(
                    'filoblu_storelocator_stores', //table name
                    'title',    // index name
                    [
                        'title'   // filed or column name
                    ],
                    AdapterInterface::INDEX_TYPE_FULLTEXT //type of index
                );
            }
        }

        if (version_compare($context->getVersion(), '1.0.2') < 0) {

            //code to upgrade to 1.0.2

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'store_ids' => [
                        'type' => Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'Store ids'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.3') < 0) {

            //code to upgrade to 1.0.3

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'street' => [
                        'type' => Table::TYPE_TEXT,
                        255,
                        'nullable' => true,
                        'comment' => 'Street'
                    ],
                    'postcode' => [
                        'type' => Table::TYPE_TEXT,
                        20,
                        'nullable' => true,
                        'comment' => 'Postcode'
                    ],
                    'city' => [
                        'type' => Table::TYPE_TEXT,
                        100,
                        'nullable' => true,
                        'comment' => 'City'
                    ],
                    'country' => [
                        'type' => Table::TYPE_TEXT,
                        100,
                        'nullable' => true,
                        'comment' => 'Country'
                    ],
                    'phone_1' => [
                        'type' => Table::TYPE_TEXT,
                        30,
                        'nullable' => true,
                        'comment' => 'Phone 1'
                    ],
                    'phone_2' => [
                        'type' => Table::TYPE_TEXT,
                        30,
                        'nullable' => true,
                        'comment' => 'Phone 2'
                    ],
                    'fax' => [
                        'type' => Table::TYPE_TEXT,
                        30,
                        'nullable' => true,
                        'comment' => 'Fax'
                    ],
                    'email' => [
                        'type' => Table::TYPE_TEXT,
                        100,
                        'nullable' => true,
                        'comment' => 'Email'
                    ],
                    'website_url' => [
                        'type' => Table::TYPE_TEXT,
                        100,
                        'nullable' => true,
                        'comment' => 'Website Url'
                    ],
                    'additional_text' => [
                        'type' => Table::TYPE_TEXT,
                        '2M',
                        'nullable' => true,
                        'comment' => 'Additional Text'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.4') < 0) {

            //code to upgrade to 1.0.4

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'marker_image' => [
                        'type' => Table::TYPE_TEXT,
                        255,
                        'nullable' => true,
                        'comment' => 'Marker Image'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.5') < 0) {

            //code to upgrade to 1.0.5
            /**
             * Create table 'tags'
             */
            if (!$setup->tableExists('filoblu_storelocator_tags')) {
                $table = $setup->getConnection()->newTable(
                    $setup->getTable('filoblu_storelocator_tags'))
                    ->addColumn(
                        'tag_id',
                        Table::TYPE_INTEGER,
                        null,
                        ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                        'Tag Id'
                    )->addColumn(
                        'enabled',
                        Table::TYPE_INTEGER,
                        null,
                        ['nullable' => false, 'default' => '0'],
                        'Enabled'
                    )->addColumn(
                        'name',
                        Table::TYPE_TEXT,
                        255,
                        ['nullable' => false],
                        'Name'
                    )->addColumn(
                        'description',
                        Table::TYPE_TEXT,
                        255,
                        ['nullable' => true],
                        'Description'
                    )->addColumn(
                        'image',
                        Table::TYPE_TEXT,
                        255,
                        [],
                        'Image'
                    )->setComment(
                        'tags list'
                    );
                $setup->getConnection()->createTable($table);
            }

            if (!$setup->tableExists('filoblu_storelocator_store_tag')) {
                $table = $setup->getConnection()
                    ->newTable($setup->getTable('filoblu_storelocator_store_tag'));
                $table->addColumn(
                    'store_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true,
                    ],
                    'Store Id'
                )
                    ->addColumn(
                        'tag_id',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'unsigned' => true,
                            'nullable' => false,
                            'primary' => true,
                        ],
                        'Tag Id'
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_tag', ['store_id']),
                        ['store_id']
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_tag', ['tag_id']),
                        ['tag_id']
                    )
                    ->addForeignKey(
                        $setup->getFkName(
                            'filoblu_storelocator_store_tag',
                            'store_id',
                            'filoblu_storelocator_stores',
                            'store_id'
                        ),
                        'store_id',
                        $setup->getTable('filoblu_storelocator_stores'),
                        'store_id',
                        Table::ACTION_CASCADE
                    )
                    ->addForeignKey(
                        $setup->getFkName(
                            'filoblu_storelocator_store_tag',
                            'tag_id',
                            'filoblu_storelocator_tags',
                            'tag_id'
                        ),
                        'tag_id',
                        $setup->getTable('filoblu_storelocator_tags'),
                        'tag_id',
                        Table::ACTION_CASCADE
                    )
                    ->addIndex(
                        $setup->getIdxName(
                            'filoblu_storelocator_store_tag',
                            [
                                'store_id',
                                'tag_id'
                            ],
                            AdapterInterface::INDEX_TYPE_UNIQUE
                        ),
                        [
                            'store_id',
                            'tag_id'
                        ],
                        [
                            'type' => AdapterInterface::INDEX_TYPE_UNIQUE
                        ]
                    )
                    ->setComment('Store To Tag Link Table');
                $setup->getConnection()->createTable($table);
            }
        }

        if (version_compare($context->getVersion(), '1.0.6') < 0) {

            //code to upgrade to 1.0.6
            /**
             * Create table 'image'
             */
            if (!$setup->tableExists('filoblu_storelocator_images')) {
                $table = $setup->getConnection()->newTable(
                    $setup->getTable('filoblu_storelocator_images'))
                    ->addColumn(
                        'image_id',
                        Table::TYPE_INTEGER,
                        null,
                        ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                        'Image Id'
                    )->addColumn(
                        'enabled',
                        Table::TYPE_INTEGER,
                        null,
                        ['nullable' => false, 'default' => '0'],
                        'Enabled'
                    )->addColumn(
                        'title',
                        Table::TYPE_TEXT,
                        255,
                        ['nullable' => false],
                        'Title'
                    )->addColumn(
                        'description',
                        Table::TYPE_TEXT,
                        255,
                        ['nullable' => true],
                        'Description'
                    )->addColumn(
                        'image',
                        Table::TYPE_TEXT,
                        255,
                        [],
                        'Image'
                    )->setComment(
                        'image list'
                    );
                $setup->getConnection()->createTable($table);
            }

            if (!$setup->tableExists('filoblu_storelocator_store_image')) {
                $table = $setup->getConnection()
                    ->newTable($setup->getTable('filoblu_storelocator_store_image'));
                $table->addColumn(
                    'store_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true,
                    ],
                    'Store Id'
                )
                    ->addColumn(
                        'image_id',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'unsigned' => true,
                            'nullable' => false,
                            'primary' => true,
                        ],
                        'Image Id'
                    )
                    ->addColumn(
                        'position',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'nullable' => false,
                            'default' => '0'
                        ],
                        'Position'
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_image', ['store_id']),
                        ['store_id']
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_image', ['image_id']),
                        ['image_id']
                    )
                    ->addForeignKey(
                        $setup->getFkName(
                            'filoblu_storelocator_store_image',
                            'store_id',
                            'filoblu_storelocator_stores',
                            'store_id'
                        ),
                        'store_id',
                        $setup->getTable('filoblu_storelocator_stores'),
                        'store_id',
                        Table::ACTION_CASCADE
                    )
                    ->addForeignKey(
                        $setup->getFkName(
                            'filoblu_storelocator_store_image',
                            'image_id',
                            'filoblu_storelocator_images',
                            'image_id'
                        ),
                        'image_id',
                        $setup->getTable('filoblu_storelocator_images'),
                        'image_id',
                        Table::ACTION_CASCADE
                    )
                    ->addIndex(
                        $setup->getIdxName(
                            'filoblu_storelocator_store_image',
                            [
                                'store_id',
                                'image_id'
                            ],
                            AdapterInterface::INDEX_TYPE_UNIQUE
                        ),
                        [
                            'store_id',
                            'image_id'
                        ],
                        [
                            'type' => AdapterInterface::INDEX_TYPE_UNIQUE
                        ]
                    )
                    ->setComment('Store To Image Link Table');
                $setup->getConnection()->createTable($table);
            }
        }

        if (version_compare($context->getVersion(), '1.0.7') < 0) {

            //code to upgrade to 1.0.7
            /**
             * Create table 'working-times'
             */

            if (!$setup->tableExists('filoblu_storelocator_store_workingtimes')) {
                $table = $setup->getConnection()
                    ->newTable($setup->getTable('filoblu_storelocator_store_workingtimes'));
                $table
                    ->addColumn(
                        'workingtime_id',
                        Table::TYPE_INTEGER,
                        null,
                        ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                        'Working Times Id'
                    )
                    ->addColumn(
                        'store_id',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'unsigned' => true,
                            'nullable' => false,
                            'primary' => true,
                        ],
                        'Store Id'
                    )
                    ->addColumn(
                        'day',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'unsigned' => true,
                            'nullable' => false,
                            'primary' => true,
                        ],
                        'Day (1=Monday,2=Tuesday..)'
                    )
                    ->addColumn(
                        'period',
                        Table::TYPE_INTEGER,
                        null,
                        [
                            'unsigned' => true,
                            'nullable' => false,
                            'primary' => true,
                        ],
                        'Period (Morning/Afternoon)'
                    )
                    ->addColumn(
                        'from',
                        Table::TYPE_TIMESTAMP,
                        null,
                        [
                            'nullable' => true,

                        ],
                        'Open From'
                    )
                    ->addColumn(
                        'to',
                        Table::TYPE_TIMESTAMP,
                        null,
                        [
                            'nullable' => true,

                        ],
                        'Open To'
                    )
                    ->addColumn(
                        'closed',
                        Table::TYPE_BOOLEAN,
                        null,
                        [
                            'nullable' => false,
                            'default' => false
                        ],
                        'Closed'
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_workingtimes', ['store_id']),
                        ['store_id']
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_workingtimes', ['day']),
                        ['day']
                    )
                    ->addIndex(
                        $setup->getIdxName('filoblu_storelocator_store_workingtimes', ['period']),
                        ['period']
                    )
                    ->addForeignKey(
                        $setup->getFkName(
                            'filoblu_storelocator_store_workingtimes',
                            'store_id',
                            'filoblu_storelocator_stores',
                            'store_id'
                        ),
                        'store_id',
                        $setup->getTable('filoblu_storelocator_stores'),
                        'store_id',
                        Table::ACTION_CASCADE
                    )
                    ->addIndex(
                        $setup->getIdxName(
                            'filoblu_storelocator_store_workingtimes',
                            [
                                'store_id',
                                'day',
                                'period',
                            ],
                            AdapterInterface::INDEX_TYPE_UNIQUE
                        ),
                        [
                            'store_id',
                            'day',
                            'period',
                        ],
                        [
                            'type' => AdapterInterface::INDEX_TYPE_UNIQUE
                        ]
                    )
                    ->setComment('Store To Working Times Link Table');
                $setup->getConnection()->createTable($table);
            }
        }

        if (version_compare($context->getVersion(), '1.0.8') < 0) {

            //code to upgrade to 1.0.8
            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'gmb_cat' => [
                        'type' => Table::TYPE_TEXT,
                        255,
                        'nullable' => true,
                        'comment' => 'Google My Business Category'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.9') < 0) {

            //code to upgrade to 1.0.9
            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'gmb_language_code' => [
                        'type' => Table::TYPE_TEXT,
                        50,
                        'nullable' => true,
                        'comment' => 'Google My Business Language Code'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.10') < 0) {

            //code to upgrade to 1.0.10
            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'gmb_location_name' => [
                        'type' => Table::TYPE_TEXT,
                        150,
                        'nullable' => true,
                        'comment' => 'Google My Business Location Name'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.1.0') < 0) {

            //code to upgrade to 1.1.0
            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'region' => [
                        'type' => Table::TYPE_TEXT,
                        255,
                        'nullable' => true,
                        'comment' => 'State/Province'
                    ],
                    'region_id' => [
                        'type' => Table::TYPE_INTEGER,
                        'nullable' => true,
                        'comment' => 'State/Province ID'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.2.1') < 0) {

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'is_enabled_for_pickup_in_store' => [
                        'type' => Table::TYPE_INTEGER,
                        'length' => 1,
                        'nullable' => true,
                        'default' => 0,
                        'comment' => 'Is Enabled For Pickup In Store'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.2.4') < 0) {

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'url_key' => [
                        'type' => Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Url Key'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }

                $setup->getConnection()->addIndex(
                    $setup->getTable('filoblu_storelocator_stores'),
                    $setup->getIdxName('url_key', ['url_key']),
                    ['url_key']
                );
            }
        }

        if (version_compare($context->getVersion(), '1.2.5') < 0) {

            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'store_code' => [
                        'type' => Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Store Code'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }

                $setup->getConnection()->addIndex(
                    $setup->getTable('filoblu_storelocator_stores'),
                    $setup->getIdxName('store_code', ['store_code']),
                    ['store_code']
                );
            }
        }

        if (version_compare($context->getVersion(), '1.2.6') < 0) {

            // Change columns type
            $connection = $setup->getConnection();

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'store_ids',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'street',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 255
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'postcode',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 10
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'city',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'country',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 3
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'country',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 3
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'country',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 3
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'phone_1',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 30
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'phone_2',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 30
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'fax',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 30
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'email',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'website_url',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 50
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'marker_image',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 255
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'gmb_cat',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'gmb_language_code',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 10
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'gmb_location_name',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );

            $connection->modifyColumn(
                $setup->getTable('filoblu_storelocator_stores'),
                'region',
                [
                    'type' => Table::TYPE_TEXT,
                    'length' => 100
                ]
            );
        }

        if (version_compare($context->getVersion(), '2.2.5') < 0) {

            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('magento_rma'), 'return_to_store_id', [
                        'type' => Table::TYPE_INTEGER,
                        'comment' => 'Return In Store ID'
                    ]
                );
            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('magento_rma'), 'return_to_store_email', [
                        'type' => Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Return In Store Email'
                    ]
                );
            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('magento_rma'), 'return_to_store_hash', [
                        'type' => Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Return In Store Hash'
                    ]
                );
            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('magento_rma'), 'return_to_store_received_date', [
                        'type' => Table::TYPE_TIMESTAMP,
                        'nullable' => true,
                        'comment' => 'Return In Store Received Date'
                    ]
                );
        }

        if (version_compare($context->getVersion(), '1.3.2') < 0) {

            $connection = $setup->getConnection();

            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('filoblu_storelocator_stores'),

                    'is_enabled_shop_details', [
                        'type' => Table::TYPE_INTEGER,
                        'length' => 1,
                        'nullable' => true,
                        'default' => 1,
                        'comment' => 'Is Enabled for Shop details'
                    ]
                );
            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('filoblu_storelocator_stores'), 'store_external_iframe_appointment', [
                        'type' => Table::TYPE_TEXT,
                        '2M',
                        'nullable' => true,
                        'comment' => 'External Iframe Appointment'
                    ]
                );
        }
        if (version_compare($context->getVersion(), '2.2.6') < 0) {
            $this->addAdditionalText2Column($setup);
        }
        if (version_compare($context->getVersion(), '2.2.7') < 0) {
            $this->addStoreFilenamePrefixColumn($setup);

        }

        if (version_compare($context->getVersion(), '2.2.9') < 0) {
            $setup->getConnection()
                ->addColumn(
                    $setup->getTable('sales_order'), 'pickup_in_store_email_send_date', [
                        'type' => Table::TYPE_TIMESTAMP,
                        'nullable' => true,
                        'comment' => 'PickUp In Store Email Send Date'
                    ]
                );
        }

        if (version_compare($context->getVersion(), '2.3.0') < 0) {
            // Get module table
            $tableName = $setup->getTable('filoblu_storelocator_stores');

            // Declare data
            $columns = [
                'is_enabled_for_return_in_store' => [
                    'type' => Table::TYPE_INTEGER,
                    'length' => 1,
                    'nullable' => true,
                    'default' => 0,
                    'comment' => 'Is Enabled For Return In Store'
                ]
            ];

            $connection = $setup->getConnection();
            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }

        if (version_compare($context->getVersion(), '3.0.0') < 0) {
            $this->addEventTable($setup, $context);
            $this->addLastUpdateColumn($setup, $context);
            $this->addOrderColumn($setup, $context);
        }

        $setup->endSetup();
    }


    /**
     * @param $setup
     */
    private function addAdditionalText2Column($setup)
    {
        $setup->getConnection()
            ->addColumn(
                $setup->getTable('filoblu_storelocator_stores'), 'additional_text_2', [
                    'type' => Table::TYPE_TEXT,
                    'comment' => 'Additional Text 2'
                ]
            );
    }

    /**
     * @param $setup
     */
    private function addStoreFilenamePrefixColumn($setup)
    {
        $setup->getConnection()
            ->addColumn(
                $setup->getTable('filoblu_storelocator_stores'), 'store_filename_prefix', [
                    'type' => Table::TYPE_TEXT,
                    'comment' => 'Store Filename Prefix'
                ]
            );
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws Zend_Db_Exception
     */
    private function addEventTable(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $table = $setup->getConnection()
            ->newTable($setup->getTable(EventsRepository::TABLE_NAME))
            ->addColumn(
                'event_id',
                Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Event Id'
            )->addColumn('store_id',
                Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false],
                'FiloBlu Store locator store id'
            )->addColumn(
                'external_event_id',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'External Event ID'
            )->addColumn(
                'country',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Country'
            )->addColumn(
                'name',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Name'
            )->addColumn(
                'description',
                Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Description'
            )->addColumn(
                'image',
                Table::TYPE_TEXT,
                255,
                [],
                'Image'
            )->addColumn(
                'category_id',
                Table::TYPE_INTEGER,
                255,
                ['nullable' => true],
                'Category ID'
            )->addColumn(
                'start',
                Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => true],
                'Event start'
            )->addColumn(
                'end',
                Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => true],
                'Event end'
            )->addColumn(
                'last_update',
                Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => true],
                'Event last update'
            )->setComment(
                'Event list'
            );

        $setup->getConnection()->createTable($table);

        $setup->getConnection()
            ->addForeignKey(
                $setup->getFkName(EventsRepository::TABLE_NAME, 'store_id', StoreRepository::TABLE_NAME, 'store_id'),
                EventsRepository::TABLE_NAME,
                'store_id',
                StoreRepository::TABLE_NAME,
                'store_id');

        foreach (['name', 'external_event_id', 'start', 'end', 'last_update'] as $column) {
            $setup->getConnection()
                ->addIndex(
                    $setup->getTable(EventsRepository::TABLE_NAME),
                    $setup->getIdxName(EventsRepository::TABLE_NAME, [$column]),
                    [$column],
                    AdapterInterface::INDEX_TYPE_INDEX
                );
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    private function addLastUpdateColumn(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->getConnection()
            ->addColumn(
                $setup->getTable("filoblu_storelocator_stores"), 'last_update', [
                    'type' => Table::TYPE_TIMESTAMP,
                    'nullable' => true,
                    'comment' => 'Last Update'
                ]
            );
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    private function addOrderColumn(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->getConnection()
            ->addColumn(
                $setup->getTable("filoblu_storelocator_stores"), 'order', [
                    'type' => Table::TYPE_INTEGER,
                    'nullable' => true,
                    'comment' => 'Order'
                ]
            );
    }
}
