<?php

namespace FiloBlu\Storelocator\Model;

use FiloBlu\Storelocator\Model\ResourceModel\WorkingTimes\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class WorkingTimes extends AbstractModel
{
    /**
     * @var \FiloBlu\Storelocator\Model\ResourceModel\WorkingTimes\CollectionFactory
     */
    protected $workingTimesCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @param \FiloBlu\Storelocator\Model\ResourceModel\WorkingTimes\CollectionFactory $workingTimesCollectionFactory
     * @param \Magento\Store\Model\StoreManagerInterface $_storeManager
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory $workingTimesCollectionFactory,
        StoreManagerInterface $_storeManager,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->workingTimesCollectionFactory = $workingTimesCollectionFactory;
        $this->_storeManager = $_storeManager;
    }

    /**
     * @param $storeId
     * @param $day
     * @param $period
     * @return \Magento\Framework\DataObject
     */
    public function loadByStoreIdDayPeriod($storeId, $day, $period)
    {
        $collection = $this->workingTimesCollectionFactory->create();

        $collection
            ->addFieldToFilter('store_id', $storeId)
            ->addFieldToFilter('day', $day)
            ->addFieldToFilter('period', $period);
        return $collection->getFirstItem();
    }

    public function loadByStoreId($storeId)
    {
        $collection = $this->workingTimesCollectionFactory->create();

        $collection->addFieldToFilter('store_id', $storeId);
        $collection->setOrder('day', 'ASC');
        $collection->setOrder('period', 'ASC');

        return $collection;
    }

    /**
     * Initialize resource model
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\WorkingTimes::class);
    }
}
