<?php

namespace FiloBlu\Storelocator\Model\Stores\Source;

use FiloBlu\Storelocator\Model\Stores;
use Magento\Framework\Data\OptionSourceInterface;

/**
 *
 */
class IsEnabled implements OptionSourceInterface
{
    /**
     * @var Stores
     */
    protected $store;

    /**
     * Constructor
     *
     * @param Stores $store
     */
    public function __construct(Stores $store)
    {
        $this->store = $store;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => '', 'value' => ''];
        $availableOptions = $this->store->getAvailableStatuses();

        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}