<?php

namespace FiloBlu\Storelocator\Model\ResourceModel\Order\Grid;


use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Sales\Model\ResourceModel\Order;
use Psr\Log\LoggerInterface as Logger;

/**
 *
 */
class Collection extends Order\Grid\Collection
{
    public function __construct(
        EntityFactory $entityFactory ,
        Logger $logger ,
        FetchStrategy $fetchStrategy ,
        EventManager $eventManager ,
        $mainTable = 'sales_order_grid' ,
        $resourceModel = Order::class
    )
    {
        parent::__construct($entityFactory , $logger , $fetchStrategy , $eventManager , $mainTable , $resourceModel);
    }

    /**
     * @inheritdoc
     */
    protected function _initSelect()
    {
        parent::_initSelect();

        $tableDescription = $this->getConnection()->describeTable($this->getMainTable());
        foreach ($tableDescription as $columnInfo) {
            $this->addFilterToMap($columnInfo['COLUMN_NAME'], 'main_table.' . $columnInfo['COLUMN_NAME']);
        }

        $this->join(
            ['so' => 'sales_order'],
            'so.entity_id = main_table.entity_id
	                AND pickup_in_store_id IS NOT NULL
                    AND pickup_in_store_email_send_date IS NULL
                    AND so.status = "complete"'
        );

        return $this;
    }
}
