<?php

namespace FiloBlu\Storelocator\Model\Plugin\Checkout;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Model\QuoteRepository;
use Magento\Framework\Exception\InputException;
use Magento\Checkout\Model\ShippingInformationManagement as ShippingManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;

/**
 *
 */
class ShippingInformationManagement
{
    /**
     * @var \FiloBlu\Storelocator\Helper\Data
     */
    private $helper;
    /**
     * @var QuoteRepository
     */
    private $quoteRepository;

    /**
     * @param \FiloBlu\Storelocator\Helper\Data $helper
     * @param \Magento\Quote\Model\QuoteRepository $quoteRepository
     */
    public function __construct(
        Data $helper,
        QuoteRepository $quoteRepository
    ) {
        $this->helper = $helper;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * @param ShippingManagement $subject
     * @param $cartId
     * @param ShippingInformationInterface $addressInformation
     * @return void
     * @throws InputException
     * @throws NoSuchEntityException
     */
    public function beforeSaveAddressInformation(
        ShippingManagement $subject,
        $cartId,
        ShippingInformationInterface $addressInformation
    ) {
        if ($this->helper->getConfig('carriers/pickupinstore/active')) {
            $quote = $this->quoteRepository->getActive($cartId);

            $shippingAddress = $addressInformation->getShippingAddress();
            $extAttributes = $shippingAddress->getExtensionAttributes();
            $methodCode = $addressInformation->getShippingMethodCode();

            if ($methodCode == 'pickupinstore') {
                if (!$extAttributes || (int)$extAttributes->getSelectedStoreId() == 0) {
                    throw new InputException(__('Select a store for pick up'));
                }
                $quote->setPickupInStoreId((int)$extAttributes->getSelectedStoreId());
                $quote->setPickupInStoreEmail(
                    $extAttributes->getSelectedStoreEmail() ? $extAttributes->getSelectedStoreEmail(
                    ) : $shippingAddress->getEmail()
                );
                return;
            }

            $quote->setPickupInStoreId(null);
            $quote->setPickupInStoreEmail(null);
        }
    }
}
