<?php

namespace FiloBlu\Storelocator\Model;

use FiloBlu\Storelocator\Model\ResourceModel\Images\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Images extends AbstractModel
{
    /**
     * @var CollectionFactory
     */
    protected $imagesCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param CollectionFactory $imagesCollectionFactory
     * @param StoreManagerInterface $storeManager
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory     $imagesCollectionFactory,
        StoreManagerInterface $storeManager,
        Context               $context,
        Registry              $registry,
        AbstractResource      $resource = null,
        AbstractDb            $resourceCollection = null,
        array                 $data = []
    ) {

        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->imagesCollectionFactory = $imagesCollectionFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * @return string[]
     */
    public function getAvailableStatuses()
    {
        return [
            0 => 'Disabled',
            1 => 'Enabled'
        ];
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getImagesByStore($storeId)
    {
        $collection = $this->getAllImages();
        $collection->addFieldToFilter('store_id', ['eq' => $storeId]);

        return $collection;
    }

    /**
     * @return mixed
     */
    public function getAllImages()
    {
        $collection = $this->imagesCollectionFactory->create();
        $collection->addFieldToFilter('enabled', ['eq' => 1]);

        return $collection;
    }

    /**
     * Initialize resource model
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\Images::class);
    }
}
