<?php

namespace FiloBlu\Storelocator\Controller\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Magento\Rma\Model\Rma;
use Magento\Rma\Model\RmaFactory;
use Magento\Sales\Api\Data\OrderInterfaceFactory;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class ConfirmReceived extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var \FiloBlu\Storelocator\Helper\Data
     */
    protected $helper;
    /**
     * @var \Magento\Sales\Api\Data\OrderInterface
     */
    protected $orderFactory;
    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \Magento\Rma\Model\RmaFactory
     */
    private $rmaFactory;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helper
     * @param OrderInterfaceFactory $orderFactory
     * @param RmaFactory $rmaFactory
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helper,
        OrderInterfaceFactory $orderFactory,
        RmaFactory $rmaFactory,
        Registry $registry,
        StoreManagerInterface $storeManager
    ) {
        $this->rmaFactory = $rmaFactory;
        $this->resultPageFactory = $resultPageFactory;
        $this->helper = $helper;
        $this->orderFactory = $orderFactory;
        $this->registry = $registry;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     *
     * @return \Magento\Framework\View\Result\Page|void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $hash = $this->getRequest()->getParam('hash');
        $rmaId = $this->getRequest()->getParam('rma_id');
        $incrementId = $this->getRequest()->getParam('increment_id');
        $storeId = $this->storeManager->getStore()->getId();

        if ((!$this->helper->getPickupInStoreEnabled($storeId) && !$this->helper->getReturnToStoreEnabled($storeId)) || !$incrementId) {
            $this->_forward('noRoute');
            return;
        }

        $order = $this->orderFactory->create();
        $order->loadByIncrementId($incrementId);

        if ($this->helper->getReturnToStoreEnabled($storeId) && $rmaId) {
            /** @var Rma $rma */
            $model = $this->rmaFactory->create();
            $rma = $model->load($rmaId);


            if ($order->getId() && $rma->getReturnToStoreHash() == $hash) {
                $this->registry->register('pickupinstore_order_confirm_received', $order);
                $resultPage = $this->resultPageFactory->create();
                $resultPage->getConfig()->getTitle()->set(
                    __('PickUp In Store - Confirmation of receipt of the package for order ') . $incrementId
                );
                return $resultPage;
            }
        } else {
            if ($order->getId()
                && $order->getPickupInStoreHash() == $hash
                && $order->getShippingMethod() == 'pickupinstore_pickupinstore'
            ) {
                $this->registry->register('pickupinstore_order_confirm_received', $order);
                $resultPage = $this->resultPageFactory->create();
                $resultPage->getConfig()->getTitle()->set(
                    __('PickUp In Store - Confirmation of receipt of the package for order ') . $incrementId
                );

                return $resultPage;
            }
        }

        $this->_forward('noRoute');
    }
}
