<?php

namespace FiloBlu\Storelocator\Block\Plugin\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class RmaReceived
{
	/**
	 * @var Data
	 */
	protected $helper;

	/**
	 * @var Registry
	 */
	protected $registry;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Data $helper
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     */
	public function __construct(
		Data     $helper,
		Registry $registry,
        StoreManagerInterface $storeManager
	)
	{
		$this->helper = $helper;
		$this->registry = $registry;
        $this->storeManager = $storeManager;
    }

	/**
	 * @param \FiloBlu\Storelocator\Block\PickUpInStore\Rmareceived $subject
	 * @param $result
	 * @return bool|mixed
	 */
	public function afterIsAlreadyConfirmed(\FiloBlu\Storelocator\Block\PickUpInStore\Rmareceived $subject, $result)
	{
		$rma = $this->registry->registry('pickupinstore_rma_received');
        $storeId = $this->storeManager->getStore()->getId();

		if ($this->helper->getUseStandardRmaMailFlow($storeId)) {
			return $result;
		}

		if ($rma->getStatus() == 'pending') {
			return false;
		}

		return true;
	}
}