<?php

namespace FiloBlu\Storelocator\Block\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Rma\Model\Rma;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class ConfirmReceived
 * @package FiloBlu\Storelocator\Block\PickUpInStore
 */
class Rmarefused extends Template
{
    /**
     * @var Data
     */
    protected $helper;
    /**
     * @var Registry
     */
    protected $_coreRegistry;
    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Http
     */
    protected $request;

    /**
     * @var \Magento\Rma\Model\Rma
     */
    protected $_rma;

    /**
     * ConfirmReceived constructor.
     * @param Context $context
     * @param Data $helper
     * @param Registry $registry
     * @param Rma $rma
     * @param Http $request
     */
    public function __construct(
        Context $context,
        Data $helper,
        Registry $registry,
        Rma $rma,
        Http $request
    ) {
        parent::__construct($context);
        $this->helper = $helper;
        $this->_coreRegistry = $registry;
        $this->_storeManager = $context->getStoreManager();
        $this->_rma = $rma;
        $this->request = $request;
    }

    /**
     * @return bool
     */
    public function isAlreadyConfirmed()
    {
        return $this->_coreRegistry->registry('pickupinstore_rma_refused')->getReturnToStoreReceivedDate() != null;
    }

    /**
     * @return string
     * @throws NoSuchEntityException
     */
    public function getBaseUrl()
    {
        return $this->_storeManager->getStore()->getBaseUrl();
    }

    /**
     * @return bool
     */
    public function getRmaStatus()
    {
        $params = $this->getParams();

        if (isset($params['rma_id']) && (int)$params['rma_id'] > 0) {
            $rma = $this->_rma->load($params['rma_id']);
            return $rma->getStatus() != 'pending';
        }
        return false;
    }

    /**
     * @return string
     */
    public function getParams()
    {
        if ($params = $this->getRequest()->getParams()) {
            $incrementId = $params['increment_id'] ?? '';
            $hash = $params['hash'] ?? '';
            $rmaId = $params['rma_id'] ?? '';
            return 'increment_id=' . $incrementId . '&hash=' . $hash . '&rma_id=' . $rmaId;
        }
        return '';
    }
}
