<?php
namespace FiloBlu\Storelocator\Block;

use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\ScopeInterface;

/**
 *
 */
class Main extends Template
{

    protected $registry;
    protected $storeManager;
    protected $scopeConfig;
    /**
     * @var StoresFactory
     */
    private $storesFactory;

    public function __construct(
        Context $context,
        StoresFactory $storesFactory,
        Registry $registry
    )
    {
        parent::__construct($context);
        $this->scopeConfig = $context->getScopeConfig();
        $this->storeManager = $context->getStoreManager();
        $this->registry = $registry;
        $this->storesFactory = $storesFactory;
    }


    public function getCurrentProductId() {
        $currentProduct = $this->registry->registry('current_product');
	    return $currentProduct->getId();
    }

    public function getAllStores()
    {
        return $this->storesFactory->create()->getAllStores();
    }

    public function getStoresByCurrentZoom($lat1, $lng1, $lat2, $lng2)
    {
        return $this->storesFactory->create()->getStoresByCurrentZoom($lat1, $lng1, $lat2, $lng2);
    }

    public function isProductAppointmentEnabled() {

        return $this->scopeConfig->getValue('filoblu_storelocator_section/general/product_appointment', ScopeInterface::SCOPE_STORE);
    }

    public function isProductInStoreEnabled() {

        return $this->scopeConfig->getValue('filoblu_storelocator_section/product_in_store/enable_product_in_store', ScopeInterface::SCOPE_STORE);
    }

    public function getWarehouseAuthorization() {

        return $this->scopeConfig->getValue('filoblu_storelocator_section/product_in_store/warehouse_api_authorization', ScopeInterface::SCOPE_STORE);
    }

    public function getWarehouseUrl() {

        return $this->scopeConfig->getValue('filoblu_storelocator_section/product_in_store/warehouse_api_url', ScopeInterface::SCOPE_STORE);
    }
}
