<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Stores\Helper;

use Magento\Backend\Helper\Data;
use Magento\Cms\Model\Wysiwyg\Config;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Data\Form\Element\Textarea;
use Magento\Framework\Escaper;
use Magento\Framework\Module\Manager;
use Magento\Framework\View\LayoutInterface;

/**
 *
 */
class Editor extends Textarea
{
    /**
     * Adminhtml data
     *
     * @var Data
     */
    protected $_backendData = null;

    /**
     * Module data
     *
     * @var Manager
     */
    protected $_moduleManager = null;

    /**
     * @var Config
     */
    protected $_wysiwygConfig;

    /**
     * @var LayoutInterface
     */
    protected $_layout;

    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param Config $wysiwygConfig
     * @param LayoutInterface $layout
     * @param Manager $moduleManager
     * @param Data $backendData
     * @param array $data
     */
    public function __construct(
        Factory $factoryElement,
        CollectionFactory $factoryCollection,
        Escaper $escaper,
        Config $wysiwygConfig,
        LayoutInterface $layout,
        Manager $moduleManager,
        Data $backendData,
        array $data = []
    ) {
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_layout = $layout;
        $this->_moduleManager = $moduleManager;
        $this->_backendData = $backendData;
        parent::__construct($factoryElement, $factoryCollection, $escaper, $data);
    }

    /**
     * Retrieve additional html and put it at the end of element html
     *
     * @return string
     */
    public function getAfterElementHtml()
    {
        $config = $this->_wysiwygConfig->getConfig();
        $config = json_encode($config->getData());

        $html = parent::getAfterElementHtml();
        if ($this->getIsWysiwygEnabled()) {
            $html = <<<HTML

<script type="text/javascript">
require([
    'jquery',
    'mage/adminhtml/wysiwyg/tiny_mce/setup'
], function(jQuery){
var config = $config,
    editor;

jQuery.extend(config, {
    settings: {
        theme_advanced_buttons1 : 'bold,italic,|,justifyleft,justifycenter,justifyright,|,' +
            'fontselect,fontsizeselect,|,forecolor,backcolor,|,link,unlink,image,|,bullist,numlist,|,code',
        theme_advanced_buttons2: null,
        theme_advanced_buttons3: null,
        theme_advanced_buttons4: null,
        theme_advanced_statusbar_location: null
    },
    files_browser_window_url: false
});

editor = new tinyMceWysiwygSetup(
    '{$this->getHtmlId()}',
    config
);

editor.turnOn();

jQuery('#{$this->getHtmlId()}')
    .addClass('wysiwyg-editor')
    .data(
        'wysiwygEditor',
        editor
    );
});
</script>
HTML;
        }
        return $html;
    }

    /**
     * Check whether wysiwyg enabled or not
     *
     * @return bool
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getIsWysiwygEnabled()
    {
        return true;
    }
}