<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Stores\Google;

use FiloBlu\Storelocator\Model\Google\Api;
use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Request\Http;

/**
 * Abstract items renderer
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class GenerateJsonGmb extends Template
{
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    protected $directory_list;
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;
    /**
     * @var \FiloBlu\Storelocator\Model\Google\Api
     */
    protected $_googleApi;
    /**
     * @var \FiloBlu\Storelocator\Model\StoresFactory
     */
    protected $_storesFactory;

    /**
     * @param Context $context
     * @param DirectoryList $directory_list
     * @param Http $request
     * @param Api $googleApi
     * @param StoresFactory $storesFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        DirectoryList $directory_list,
        Http $request,
        Api $googleApi,
        StoresFactory $storesFactory,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->directory_list = $directory_list;
        $this->request = $request;
        $this->_googleApi = $googleApi;
        $this->_storesFactory = $storesFactory;
    }

    /**
     * @return false|string
     */
    public function getGeneratedJson()
    {
        // TODO: use serializer
        return json_encode($this->_googleApi->getLocationObj($this->_storesFactory->create()->load($this->request->getParam('store_id'))));
    }
}
