<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Stores\Edit\Tab;

use Exception;
use FiloBlu\Storelocator\Model\ResourceModel\Events\{CollectionFactory, Collection};
use FiloBlu\Storelocator\Model\Stores;
use FiloBlu\Storelocator\Model\EventsFactory;
use FiloBlu\Storelocator\Model\EventsRepository;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Backend\Helper\Data;
use Magento\Framework\Registry;

/**
 *
 */
class Events extends Extended implements TabInterface
{
    /**
     * Events collection factory
     *
     * @var CollectionFactory
     */
    protected $eventsCollectionFactory;

    /**
     * Registry
     *
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var EventsFactory
     */
    private $eventsFactory;

    /**
     * @var EventsRepository
     */
    private $eventsRepository;

    /**
     * @param CollectionFactory $eventsCollectionFactory
     * @param Registry $coreRegistry
     * @param EventsFactory $eventsFactory
     * @param EventsRepository $eventsRepository
     * @param Context $context
     * @param Data $backendHelper
     * @param array $data
     */
    public function __construct(
        CollectionFactory $eventsCollectionFactory,
        Registry          $coreRegistry,
        EventsFactory     $eventsFactory,
        EventsRepository  $eventsRepository,
        Context           $context,
        Data              $backendHelper,
        array             $data = []
    ) {
        $this->eventsCollectionFactory = $eventsCollectionFactory;
        $this->coreRegistry = $coreRegistry;
        $this->eventsFactory = $eventsFactory;
        $this->eventsRepository = $eventsRepository;

        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * Set grid params
     * @noinspection MagicMethodsValidityInspection
     */
    public function _construct()
    {
        parent::_construct();
        $this->setId('events_grid');
        $this->setDefaultSort('name');
        $this->setDefaultDir('ASC');
        $this->setUseAjax(true);
    }

    /**
     * @return Stores
     */
    public function getStore()
    {
        return $this->coreRegistry->registry('storelocator_store');
    }

    /**
     * Retrieve selected Tags
     * @return array
     */
    public function getSelectedTags()
    {
        return $this->getStore()->getOldTags();
    }

    /**
     * @param $item
     * @return string
     */
    public function getRowUrl($item)
    {
        return '#';
    }

    /**
     * get grid url
     *
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl(
            '*/*/eventsGrid',
            [
                'store_id' => $this->getStore()->getStoreId()
            ]
        );
    }

    /**
     * @return bool
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * @return string
     */
    public function getTabTitle()
    {
        return $this->getTabLabel();
    }

    /**
     * @return string
     */
    public function getTabLabel()
    {
        return __('Events');
    }

    /**
     * @return bool
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getTabUrl()
    {
        return $this->getUrl('filoblustorelocatoradmin/stores/events', ['_current' => true]);
    }

    /**
     * @return string
     */
    public function getTabClass()
    {
        return 'ajax only';
    }

    /**
     * prepare the collection
     * @return $this
     */
    protected function _prepareCollection()
    {
        /** @var Collection $collection */
        $collection = $this->eventsCollectionFactory->create();

        if ($this->getStore()->getStoreId()) {
            $collection->addFieldToFilter('store_id', $this->getStore()->getStoreId());
        }

        $this->setCollection($collection);
        parent::_prepareCollection();
        return $this;
    }

    /**
     * @return $this
     */
    protected function _prepareMassaction()
    {
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'event_id',
            [
                'header'           => __('ID'),
                'sortable'         => true,
                'index'            => 'event_id',
                'type'             => 'number',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'store_id',
            [
                'header'           => __('Store Id'),
                'index'            => 'store_id',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );
        $this->addColumn(
            'name',
            [
                'header'           => __('Name'),
                'index'            => 'name',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

//        $this->addColumn(
//            'external_event_id',
//            [
//                'header'           => __('External Event ID'),
//                'index'            => 'external_event_id',
//                'header_css_class' => 'col-name',
//                'column_css_class' => 'col-name'
//            ]
//        );

        $this->addColumn(
            'country',
            [
                'header'           => __('Country'),
                'index'            => 'country',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        return $this;
    }
}
