<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Images\Edit;

use FiloBlu\Storelocator\Block\Adminhtml\Stores\Helper\Editor;
use FiloBlu\Storelocator\Block\Adminhtml\Stores\Helper\Image;
use FiloBlu\Storelocator\Model\Images;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Store\Model\System\Store;

/**
 * Adminhtml storelocator image edit form
 */
class Form extends Generic
{

    /**
     * @var Store
     */
    protected $_systemStore;


    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param Store $systemStore
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Store $systemStore,
        array $data = []
    ) {
        $this->_systemStore = $systemStore;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Init form
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('storelocator_image_form');
        $this->setTitle(__('Image Information'));
    }

    /**
     * Prepare form
     *
     * @return $this
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function _prepareForm()
    {
        /** @var Images $model */
        $model = $this->_coreRegistry->registry('storelocator_image');

        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create(
            [
                'data' => [
                    'id'      => 'edit_form',
                    'action'  => $this->getData('action'),
                    'method'  => 'post',
                    'enctype' => 'multipart/form-data',
                ]
            ]
        );

        $form->setHtmlIdPrefix('storelocator_image_');

        // ## General Information ##
        $fieldset = $form->addFieldset(
            'base_fieldset',
            ['legend' => __('General Information'), 'class' => 'fieldset-wide']
        );

        $fieldset->addType('image', Image::class);

        if ($model->getImageId()) {
            $fieldset->addField('image_id', 'hidden', ['name' => 'image_id']);
        }

        $fieldset->addField(
            'title',
            'text',
            [
                'name'     => 'title',
                'label'    => __('Title'),
                'title'    => __('Title'),
                'required' => true
            ]
        );

        $fieldset->addField(
            'enabled',
            'select',
            [
                'label'    => __('Status'),
                'title'    => __('Status'),
                'name'     => 'enabled',
                'required' => true,
                'options'  => ['1' => __('Enabled'), '0' => __('Disabled')]
            ]
        );

        if (!$model->getId()) {
            $model->setData('enabled', '1');
        }

        $fieldset->addField(
            'description',
            Editor::class,
            [
                'name'  => 'description',
                'label' => __('Description'),
                'title' => __('Description'),
            ]
        );

        $fieldset->addField(
            'image',
            'image',
            [
                'name'     => 'image',
                'label'    => __('Image'),
                'title'    => __('Image'),
                'required' => true
            ]
        );

        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}