define(
  [
    'jquery',
    'ko',
    'uiComponent',
    'underscore',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/action/select-shipping-method',
    'Magento_Checkout/js/model/shipping-service',
    'FiloBlu_Storelocator/js/action/create-shipping-address',
    'uiRegistry',
    'Magento_Customer/js/model/address-list',
    'Magento_Checkout/js/action/select-shipping-address',
    'Magento_Checkout/js/checkout-data'
  ],
  function($, ko, Component, _ , quote, selectShippingMethodAction, shippingService, createShippingAddress, uiRegistry, addressList, selectShippingAddress,checkoutData) {
    'use strict';
    return Component.extend({

      initObservable: function() {

        this.pickUpInStoreSelected = ko.computed(function() {

        var method = quote.shippingMethod();
        var selectedMethod = method != null ? method.method_code : null;
        var shippingAddressForm = $("#co-shipping-form");
        var customerAddressesElements = $(".addresses,.action-show-popup");

        if (this.oldMethodSelected == "pickupinstore"  && selectedMethod != "pickupinstore") {
          this.resetPickupAddress();
        }

        if (this.oldMethodSelected == "pickupinstore"  && selectedMethod != "pickupinstore" && addressList().length == 0) {
          this.resetShippingAddress();
        }

        this.oldMethodSelected = selectedMethod;

        if (selectedMethod == "pickupinstore") {
          if (shippingAddressForm.length) {
            shippingAddressForm.hide();
            shippingAddressForm[0].reset();
          }

          if (customerAddressesElements.length) {
            customerAddressesElements.hide();
          }

          this.hideFormOnRender = true;

          return "1";
        }
        else {

          if (shippingAddressForm.length) {
            shippingAddressForm.show();
          }

          if (customerAddressesElements.length) {
            customerAddressesElements.show();
          }

          this.hideFormOnRender = false;

          return "0";
        }

        }, this);

        return this;
      },
      onElementRender: function() {

        var shippingAddressForm = $("#co-shipping-form");
        var customerAddressesElements = $(".addresses,.action-show-popup");

        if (this.hideFormOnRender) {
          if (shippingAddressForm.length) {
            shippingAddressForm.hide();
            shippingAddressForm[0].reset();
          }

          if (customerAddressesElements.length) {
            customerAddressesElements.hide();
          }
        }

      },
      checkPickUpInStoreShippingMethod: function() {
        var pickupInStoreMethod = _.find(shippingService.getShippingRates()(), function (rate) {
            return rate.method_code == "pickupinstore";
        });

        if (pickupInStoreMethod) {
          selectShippingMethodAction(pickupInStoreMethod);
          checkoutData.setSelectedShippingRate(pickupInStoreMethod['carrier_code'] + '_' + pickupInStoreMethod['method_code']);
        }

         return true;

      },
      uncheckPickUpInStoreShippingMethod: function() {

        this.resetPickupAddress();

        var firstSelectedMethod = _.find(shippingService.getShippingRates()(), function (rate) {
            return rate.method_code != "pickupinstore" && rate.available;
        });

        if (firstSelectedMethod) {
          selectShippingMethodAction(firstSelectedMethod);
          checkoutData.setSelectedShippingRate(firstSelectedMethod['carrier_code'] + '_' + firstSelectedMethod['method_code']);
        }

         return true;

      },
      resetPickupAddress: function() {

        var pickupInStoreAddress = _.find(addressList(), function (address) {
            return address.getType() == "pickup-address";
        });

        if (pickupInStoreAddress) {
          addressList.remove(pickupInStoreAddress);
        }

        var selectedFirstAddress = _.find(addressList(), function (address) {
            return address.getType() != "pickup-address";
        });

        if (selectedFirstAddress) {
          selectShippingAddress(selectedFirstAddress);
          checkoutData.setSelectedShippingAddress(selectedFirstAddress.getKey());
        }
      },
      resetShippingAddress: function() {

        // reset shipping address

        var newShippingAddressData =  {};
        var shippingAddress = createShippingAddress(newShippingAddressData);

        selectShippingAddress(shippingAddress);
        checkoutData.setSelectedShippingAddress(shippingAddress.getKey());
        checkoutData.setShippingAddressFromData($.extend(true, {}, shippingAddress));
        uiRegistry.get('checkout.steps.shipping-step.shippingAddress').reset()

      }

    });
  }
);
