define([
    'ko',
    'Magento_Checkout/js/model/quote',
],function (ko,quote) {
    'use strict';

    var mixin = {

        isButtonEnabled: function () {
            if (!quote.isVirtual() || (quote.shippingMethod() && quote.shippingMethod().method_code == "pickupinstore")) {
                return  ko.observable(quote.billingAddress() != null)
            }
            return true
        },

        defaults: {
            template: 'FiloBlu_Storelocator/payment/paypal-express'
        }
    };

    return function (target) {
        return target.extend(mixin);
    };
});