define([
    'jquery',
    'underscore',
    'jquery/ui',
    'Magento_Ui/js/modal/modal'
], function ($,_) {
    'use strict';

    $.widget('filoblu.appointment_wishlist', {

        _create: function () {

            var self = this,
                wishlistSection = self.element,
                wishlistPanel = $('.wishlist-panel',wishlistSection),
                wishlistWrapper = $('.wishlist-wrapper',wishlistSection),
                viewButton = $('#view-wishlist',wishlistPanel),
                productSelect = $('.wishlist-checkbox',wishlistWrapper);

            viewButton.on('click', function(e){
                wishlistPanel.fadeOut(function () {
                    wishlistWrapper.fadeIn();
                });

            });

            productSelect.on('change', function(e){
                var checkboxValue = $(this).val();

                if (!window.wishlistItems.includes(checkboxValue)) {
                    window.wishlistItems.push(checkboxValue);
                } else {
                    window.wishlistItems = _.without(window.wishlistItems, checkboxValue)
                }
            });
        }


    });

    return $.filoblu.appointment_wishlist;
});
