<?php

namespace FiloBlu\Storelocator\Ui\Component\Listing\Column;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 *
 */
class StoreActions extends Column
{
    /** Url path */
    const STORE_URL_PATH_EDIT = 'filoblustorelocatoradmin/stores/edit';
    const STORE_URL_PATH_DELETE = 'filoblustorelocatoradmin/stores/delete';
    const STORE_URL_PATH_GENERATEJSONGMB = 'filoblustorelocatoradmin/stores/generatejsongmb';

    /** @var UrlInterface */
    protected $urlBuilder;

    /**
     * @var string
     */
    private $editUrl;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     * @param string $editUrl
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = [],
        array $data = [],
        $editUrl = self::STORE_URL_PATH_EDIT
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
        $this->editUrl = $editUrl;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $name = $this->getData('name');
                if (isset($item['store_id'])) {
                    $item[$name]['edit'] = [
                        'href'  => $this->urlBuilder->getUrl($this->editUrl, ['id' => $item['store_id']]),
                        'label' => __('Edit')
                    ];
                    $item[$name]['delete'] = [
                        'href'    => $this->urlBuilder->getUrl(
                            self::STORE_URL_PATH_DELETE,
                            ['id' => $item['store_id']]
                        ),
                        'label'   => __('Delete'),
                        'confirm' => [
                            'title'   => __('Delete "${ $.$data.title }"'),
                            'message' => __('Are you sure you wan\'t to delete a "${ $.$data.title }" record?')
                        ]
                    ];
                    $item[$name]['generatejsongmb'] = [
                        'href'  => $this->urlBuilder->getUrl(
                            self::STORE_URL_PATH_GENERATEJSONGMB,
                            ['id' => $item['store_id']]
                        ),
                        'label' => __('Generate Json Gmb')
                    ];
                }
            }
        }

        return $dataSource;
    }
}